/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest;

import com.ibm.rules.res.model.rest.DeploymentOperation;
import com.ibm.rules.rest.RESTCollection;
import com.ibm.rules.rest.annotation.HideRESTCollectionFunction;
import com.ibm.rules.rest.io.RESTCollectionJsonSerializer;
import ilog.rules.res.model.internal.IlrDeploymentOperation;
import ilog.rules.res.model.internal.IlrDeploymentReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="report")
@JsonSerialize(using=RESTCollectionJsonSerializer.class)
@HideRESTCollectionFunction
public class DeploymentReport
extends RESTCollection<IlrDeploymentOperation, DeploymentOperation> {
    public static DeploymentReport DEFAULT_OUT_INSTANCE = new DeploymentReport();
    private IlrDeploymentReport report;
    private List<DeploymentOperation> forcedReport;

    public DeploymentReport() {
        super(Locale.ENGLISH);
    }

    public DeploymentReport(IlrDeploymentReport report, Locale locale) {
        super(locale);
        this.report = report;
    }

    @XmlElement(name="operation")
    public Collection<DeploymentOperation> getOperations() {
        return this.getRESTCollection();
    }

    @Override
    @JsonIgnore
    public Collection<IlrDeploymentOperation> getInitialCollection() {
        if (this.report == null) {
            return null;
        }
        return this.report.getOperations();
    }

    @Override
    public DeploymentOperation toRESTObject(IlrDeploymentOperation internalObject, Locale locale) {
        DeploymentOperation result = new DeploymentOperation();
        if (internalObject.getPath() != null) {
            result.setInitialPath(internalObject.getPath().toString());
        }
        if (internalObject.getResult() != null) {
            result.setResultPath(internalObject.getResult().toString());
        }
        switch (internalObject.getOperationType()) {
            case 1: {
                result.setOperationType("ADD");
                break;
            }
            case 2: {
                result.setOperationType("CHANGE_VERSION_AND_ADD");
                break;
            }
            case 3: {
                result.setOperationType("REPLACE");
                break;
            }
            case 0: {
                result.setOperationType("UPDATE");
                break;
            }
        }
        result.setManagedXomGeneratedProperty(internalObject.getManagedXOMGeneratedProperty());
        return result;
    }

    @Override
    @JsonIgnore
    public Collection<DeploymentOperation> getForcedRESTCollection() {
        return this.forcedReport;
    }

    static {
        DeploymentReport.DEFAULT_OUT_INSTANCE.forcedReport = new ArrayList<DeploymentOperation>();
        DeploymentReport.DEFAULT_OUT_INSTANCE.forcedReport.add(DeploymentOperation.DEFAULT_OUT_INSTANCE);
    }
}

