/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest;

import com.ibm.rules.res.model.XOMLibraryId;
import com.ibm.rules.res.model.XOMLibraryInformation;
import com.ibm.rules.res.model.internal.XOMLibraryIdImpl;
import com.ibm.rules.res.model.rest.Library;
import com.ibm.rules.res.model.rest.Parts;
import com.ibm.rules.res.model.rest.io.RESTLibrariesJsonDeserializer;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTCollection;
import com.ibm.rules.rest.io.RESTCollectionJsonSerializer;
import ilog.rules.res.model.IlrPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="libraries")
@JsonSerialize(using=RESTCollectionJsonSerializer.class)
@JsonDeserialize(using=RESTLibrariesJsonDeserializer.class)
public class Libraries
extends RESTCollection<XOMLibraryId, Library> {
    public static Libraries DEFAULT_IN_INSTANCE;
    public static Libraries DEFAULT_OUT_INSTANCE;
    private Collection<Library> libraries;
    private Collection<XOMLibraryId> initialLibraries;
    private Parts parts;
    private XOMRepositoryDAO dao;

    public Libraries() {
    }

    public Libraries(XOMRepositoryDAO dao, Collection<XOMLibraryId> initialLibraries, Locale locale, Parts parts) {
        super(locale);
        this.initialLibraries = initialLibraries;
        this.parts = parts;
        this.dao = dao;
    }

    @XmlElement(name="library")
    public Collection<Library> getLibraries() {
        if (this.libraries != null) {
            return this.libraries;
        }
        if (this.initialLibraries == null) {
            this.libraries = new ArrayList<Library>();
            return this.libraries;
        }
        return this.getRESTCollection();
    }

    public void setLibraries(Collection<Library> libraries) {
        this.libraries = libraries;
    }

    @Override
    @JsonIgnore
    public Collection<XOMLibraryId> getInitialCollection() {
        return this.initialLibraries;
    }

    @Override
    public Library toRESTObject(XOMLibraryId internalObject, Locale locale) {
        return Libraries.toRESTObject(this.dao, internalObject, this.parts);
    }

    public static Library toRESTObject(XOMRepositoryDAO dao, XOMLibraryId internalObject, Parts parts) {
        if (internalObject == null) {
            return null;
        }
        Library result = new Library(internalObject);
        result.setId(new IlrPath(internalObject.getName(), internalObject.getVersion()).toString().substring(1));
        if (parts.isDisplayed("uri")) {
            result.setUri("reslib://" + XOMLibraryIdImpl.getInternalName(internalObject));
        }
        if (parts.isDisplayed("name")) {
            result.setName(internalObject.getName());
        }
        if (parts.isDisplayed("version")) {
            result.setVersion(internalObject.getVersion().toString());
        }
        if (parts.isDisplayed("creationDate")) {
            result.setCreationDate(internalObject.getDate());
        }
        if (parts.isDisplayed("content")) {
            try {
                if (dao != null) {
                    String[] list = dao.getContent(internalObject);
                    result.setContent(list);
                } else if (internalObject instanceof XOMLibraryInformation) {
                    String[] list = ((XOMLibraryInformation)internalObject).getResources();
                    result.setContent(list);
                }
            }
            catch (Exception e) {
                throw new HTTPError(500, e);
            }
        }
        return result;
    }

    @Override
    public Collection<Library> getForcedRESTCollection() {
        return this.libraries;
    }

    static {
        ArrayList<Library> collin = new ArrayList<Library>();
        collin.add(Library.DEFAULT_IN_INSTANCE);
        DEFAULT_IN_INSTANCE = new Libraries();
        DEFAULT_IN_INSTANCE.setLibraries(collin);
        ArrayList<Library> collout = new ArrayList<Library>();
        collout.add(Library.DEFAULT_OUT_INSTANCE);
        DEFAULT_OUT_INSTANCE = new Libraries();
        DEFAULT_OUT_INSTANCE.setLibraries(collout);
    }
}

