/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest;

import java.util.ArrayList;
import java.util.List;

public class Parts {
    public static final String PARAM_PARTS = "parts";
    public static final String ALL_PART = "all";
    public static final String NONE_PART = "none";
    private final List<String> partsIgnoreCase = new ArrayList<String>();
    private boolean all = false;
    private boolean none = false;

    public Parts() {
        this.none = true;
    }

    public Parts(String fromQuery) {
        this.parseQueryString(fromQuery);
    }

    private void parseQueryString(String fromQuery) {
        String[] parts;
        if (fromQuery == null) {
            this.all = true;
            this.none = false;
            return;
        }
        for (String part : parts = fromQuery.split("\\|")) {
            if (NONE_PART.equalsIgnoreCase(part)) {
                this.all = false;
                this.none = true;
                continue;
            }
            if (ALL_PART.equalsIgnoreCase(part)) {
                this.all = true;
                this.none = false;
                continue;
            }
            this.addPart(part);
        }
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean isNone() {
        return this.none;
    }

    public boolean isDisplayed(String name) {
        if (this.all) {
            return true;
        }
        return this.partsIgnoreCase.contains(name.toLowerCase());
    }

    public boolean isPart(String name) {
        return this.partsIgnoreCase.contains(name.toLowerCase());
    }

    public void addPart(String name) {
        this.partsIgnoreCase.add(name.toLowerCase());
    }
}

