/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest;

import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.rest.RESTXmlAdapter;
import ilog.rules.util.IlrBase64DecoderStream;
import ilog.rules.util.IlrBase64EncoderStream;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="resource")
@XmlType(propOrder={"id", "uri", "name", "version", "creationDate", "sha1", "content"})
@JsonPropertyOrder(value={"id", "uri", "name", "version", "creationDate", "sha1", "content"})
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Resource {
    public static Resource DEFAULT_IN_INSTANCE = new Resource();
    public static Resource DEFAULT_OUT_INSTANCE;
    private String name;
    private String version;
    private Date creationDate;
    private String sha1;
    private String id;
    private String uri;
    private byte[] content;
    private XOMResourceId internalObject;

    public Resource() {
    }

    public Resource(XOMResourceId internalObject) {
        this.internalObject = internalObject;
    }

    @XmlElement(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="uri")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlElement(name="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElement(name="creationDate")
    @XmlJavaTypeAdapter(value=RESTXmlAdapter.class)
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @XmlElement(name="sha1")
    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    @XmlElement(name="content")
    public String getContent() {
        if (this.content == null) {
            return null;
        }
        return new String(IlrBase64EncoderStream.encode(this.content));
    }

    @XmlTransient
    @JsonIgnore
    public byte[] getByteContent() {
        return this.content;
    }

    public void setContent(String content) {
        try {
            this.content = IlrBase64DecoderStream.decode(content.getBytes());
        }
        catch (Exception e) {
            this.content = content.getBytes();
        }
    }

    public void setByteContent(byte[] content) {
        this.content = content;
    }

    @JsonIgnore
    public XOMResourceId getInternalObject() {
        return this.internalObject;
    }

    static {
        Resource.DEFAULT_IN_INSTANCE.name = "@@com.ibm.rules.res.model.rest.doc#resourceName@@";
        Resource.DEFAULT_IN_INSTANCE.content = "xom.jar".getBytes();
        DEFAULT_OUT_INSTANCE = new Resource();
        Resource.DEFAULT_OUT_INSTANCE.id = "@@com.ibm.rules.res.model.rest.doc#resourceId@@";
        Resource.DEFAULT_OUT_INSTANCE.uri = "@@com.ibm.rules.res.model.rest.doc#resourceUri@@";
        Resource.DEFAULT_OUT_INSTANCE.name = "@@com.ibm.rules.res.model.rest.doc#resourceName@@";
        Resource.DEFAULT_OUT_INSTANCE.version = "@@com.ibm.rules.res.model.rest.doc#resourceVersion@@";
        Resource.DEFAULT_OUT_INSTANCE.sha1 = "@@com.ibm.rules.res.model.rest.doc#resourceSha1@@";
        Resource.DEFAULT_OUT_INSTANCE.creationDate = new Date();
        Resource.DEFAULT_OUT_INSTANCE.content = "xom.jar".getBytes();
    }
}

