/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest;

import com.ibm.rules.res.model.rest.Parts;
import com.ibm.rules.res.model.rest.RuleApp;
import com.ibm.rules.res.model.rest.Rulesets;
import com.ibm.rules.res.model.rest.io.RESTRuleAppsJsonDeserializer;
import com.ibm.rules.rest.RESTCollection;
import com.ibm.rules.rest.RESTProperties;
import com.ibm.rules.rest.io.RESTCollectionJsonSerializer;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="ruleApps")
@JsonSerialize(using=RESTCollectionJsonSerializer.class)
@JsonDeserialize(using=RESTRuleAppsJsonDeserializer.class)
public class RuleApps
extends RESTCollection<IlrMutableRuleAppInformation, RuleApp> {
    public static RuleApps DEFAULT_IN_INSTANCE;
    public static RuleApps DEFAULT_OUT_INSTANCE;
    private IlrMutableRepository repository;
    private Parts parts;
    private Collection<RuleApp> ruleapps;

    public RuleApps() {
    }

    public RuleApps(IlrMutableRepository repository, Locale locale, Parts parts) {
        super(locale);
        this.repository = repository;
        this.parts = parts;
    }

    @XmlElement(name="ruleApp")
    public Collection<RuleApp> getRuleApps() {
        if (this.ruleapps != null) {
            return this.ruleapps;
        }
        return this.getRESTCollection();
    }

    public void setRuleApps(Collection<RuleApp> ruleapps) {
        this.ruleapps = ruleapps;
    }

    @Override
    @JsonIgnore
    public Collection<IlrMutableRuleAppInformation> getInitialCollection() {
        if (this.repository != null) {
            Set<IlrMutableRuleAppInformation> initialCollection = this.repository.getRuleApps();
            return initialCollection;
        }
        return null;
    }

    @Override
    public RuleApp toRESTObject(IlrMutableRuleAppInformation internalObject, Locale locale) {
        return RuleApps.toRESTObject(internalObject, locale, this.parts);
    }

    public static RuleApp toRESTObject(IlrMutableRuleAppInformation internalObject, Locale locale, Parts parts) {
        if (internalObject == null) {
            return null;
        }
        RuleApp result = new RuleApp(internalObject);
        result.setId(new IlrPath(internalObject.getName(), internalObject.getVersion()).toString().substring(1));
        if (parts.isDisplayed("name")) {
            result.setName(internalObject.getName());
        }
        if (parts.isDisplayed("version")) {
            result.setVersion(internalObject.getVersion().toString());
        }
        if (parts.isDisplayed("creationDate")) {
            result.setCreationDate(internalObject.getCreationDate());
        }
        if (parts.isDisplayed("description")) {
            result.setDescription(internalObject.getDescription() == null ? "" : internalObject.getDescription());
        }
        if (parts.isDisplayed("displayName")) {
            result.setDisplayName(internalObject.getDisplayName());
        }
        if (parts.isDisplayed("properties")) {
            result.setProperties(new RESTProperties(internalObject.getProperties(), locale));
        }
        if (parts.isDisplayed("rulesetCount")) {
            result.setRulesetCount(internalObject.getRulesets().size());
        }
        if (parts.isDisplayed("rulesets")) {
            result.setRulesets(new Rulesets(internalObject, locale, parts));
        }
        return result;
    }

    @Override
    public Collection<RuleApp> getForcedRESTCollection() {
        return this.ruleapps;
    }

    static {
        ArrayList<RuleApp> collin = new ArrayList<RuleApp>();
        collin.add(RuleApp.DEFAULT_IN_INSTANCE);
        DEFAULT_IN_INSTANCE = new RuleApps();
        DEFAULT_IN_INSTANCE.setRuleApps(collin);
        ArrayList<RuleApp> collout = new ArrayList<RuleApp>();
        collout.add(RuleApp.DEFAULT_IN_INSTANCE);
        DEFAULT_OUT_INSTANCE = new RuleApps();
        DEFAULT_OUT_INSTANCE.setRuleApps(collout);
    }
}

