/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest;

import com.ibm.rules.res.Stat;
import com.ibm.rules.rest.RESTProperties;
import com.ibm.rules.rest.RESTXmlAdapter;
import com.ibm.rules.rest.io.RESTCollectionJsonSerializer;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="statistics")
public class Statistics {
    public static Statistics DEFAULT_OUT_INSTANCE;
    private Map<Stat, Object> internalObject;

    public Statistics() {
    }

    public Statistics(Map<Stat, Object> internalObject) {
        this.internalObject = internalObject;
    }

    @XmlElement(name="id")
    public String getId() {
        return (String)this.internalObject.get((Object)Stat.PATH);
    }

    @XmlElement(name="isActivated")
    public boolean getIsActivated() {
        return this.getAsBoolean(Stat.ACTIVATED);
    }

    @JsonSerialize(using=RESTCollectionJsonSerializer.class, include=JsonSerialize.Inclusion.NON_NULL)
    public RESTProperties getProperties() {
        return new RESTProperties((Map)this.internalObject.get((Object)Stat.PROPERTIES), Locale.ENGLISH);
    }

    @XmlElement(name="executionCount")
    public long getExecutionCount() {
        return this.getAsLong(Stat.COUNT);
    }

    @XmlElement(name="errorCount")
    public long getErrorCount() {
        return this.getAsLong(Stat.ERRORS);
    }

    @XmlElement(name="lastErrorDate")
    @XmlJavaTypeAdapter(value=RESTXmlAdapter.class)
    public Date getLastErrorDate() {
        return (Date)this.internalObject.get((Object)Stat.LAST_ERROR_DATE);
    }

    @XmlElement(name="totalExecutionTime")
    public long getTotalExecutionTime() {
        return this.getAsLong(Stat.TOTAL);
    }

    @XmlElement(name="maxExecutionTime")
    public long getMaxExecutionTime() {
        return this.getAsLong(Stat.MAX);
    }

    @XmlElement(name="minExecutionTime")
    public long getMinExecutionTime() {
        return this.getAsLong(Stat.MIN);
    }

    @XmlElement(name="lastExecutionTime")
    public long getLastExecutionTime() {
        return this.getAsLong(Stat.LAST);
    }

    @XmlElement(name="averageExecutionTime")
    public BigDecimal getAverageTime() {
        BigDecimal averageValue = new BigDecimal(-1);
        long count = this.getAsLong(Stat.COUNT);
        if (count > 0L) {
            averageValue = new BigDecimal(this.getAsLong(Stat.TOTAL)).divide(new BigDecimal(count), 3, 6);
        }
        return averageValue;
    }

    @XmlElement(name="firstExecutionDate")
    @XmlJavaTypeAdapter(value=RESTXmlAdapter.class)
    public Date getFirstExecutionDate() {
        return (Date)this.internalObject.get((Object)Stat.FIRST_DATE);
    }

    @XmlElement(name="lastExecutionDate")
    @XmlJavaTypeAdapter(value=RESTXmlAdapter.class)
    public Date getLastExecutionDate() {
        return (Date)this.internalObject.get((Object)Stat.LAST_DATE);
    }

    @JsonIgnore
    public Map<Stat, Object> getInternalObject() {
        return this.internalObject;
    }

    private long getAsLong(Stat stat) {
        Long result = (Long)this.internalObject.get((Object)stat);
        if (result == null) {
            return 0L;
        }
        return result;
    }

    private boolean getAsBoolean(Stat stat) {
        Boolean result = (Boolean)this.internalObject.get((Object)stat);
        if (result == null) {
            return false;
        }
        return result;
    }

    static {
        HashMap<Stat, Object> tmp = new HashMap<Stat, Object>();
        DEFAULT_OUT_INSTANCE = new Statistics(tmp);
    }
}

