/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest.binding.internal;

import com.ibm.rules.res.xml.internal.JAXBContext;
import com.ibm.rules.rest.Converter;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTActionResult;
import com.ibm.rules.rest.RESTContext;
import com.ibm.rules.rest.RESTPreResponse;
import com.ibm.rules.rest.RESTServiceBinding;
import com.ibm.rules.rest.RESTServiceConsumer;
import com.ibm.rules.rest.UnknowPathException;
import com.ibm.rules.rest.io.RESTRequest;
import com.ibm.rules.rest.io.RESTResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.xml.bind.JAXBException;

public abstract class RESTServiceBindingBase
implements RESTServiceBinding {
    protected final RESTServiceConsumer service;
    protected final JAXBContext jaxbContext;

    @Override
    public abstract Converter getReader();

    public RESTServiceBindingBase(RESTServiceConsumer service) {
        this.service = service;
        service.registerReader(this.getReader());
        try {
            this.jaxbContext = JAXBContext.newInstance(service.getInvolvedClass(), null, null);
        }
        catch (JAXBException e) {
            throw new HTTPError(500, (Exception)((Object)e));
        }
    }

    @Override
    public void doMethod(RESTRequest req, RESTResponse resp, RESTContext context) throws IOException {
        try {
            Object result = this.service.invokeMethod(context);
            if (result != null) {
                if (result instanceof RESTPreResponse) {
                    RESTPreResponse preResp = (RESTPreResponse)result;
                    if (preResp.getContentDisposition() != null) {
                        resp.setHeader("Content-Disposition", preResp.getContentDisposition());
                    }
                    resp.setStatus(preResp.getStatus());
                    resp.setContentType(preResp.getContentType());
                    if (preResp.getData() != null) {
                        resp.getOutputStream().write(preResp.getData());
                    }
                } else {
                    if (result instanceof RESTActionResult) {
                        resp.setStatus(((RESTActionResult)result).getStatus());
                    }
                    resp.setContentType(context.getConverterOut().getContentType() + "; charset=UTF-8");
                    context.getConverterOut().toFormat(resp.getWriter(), result, context);
                }
            } else {
                resp.setStatus(204);
            }
            for (Map.Entry<String, String> entry : context.getHeadersOut().entrySet()) {
                resp.setHeader(entry.getKey(), entry.getValue());
            }
        }
        catch (IllegalArgumentException e) {
            this.sendError(resp, new HTTPError(400, e));
        }
        catch (IllegalAccessException e) {
            this.sendError(resp, new HTTPError(400, e));
        }
        catch (UnsupportedEncodingException e) {
            this.sendError(resp, new HTTPError(400, e));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof HTTPError) {
                this.sendError(resp, (HTTPError)e.getTargetException());
            } else {
                this.sendError(resp, new HTTPError(400, e));
            }
        }
        catch (HTTPError e) {
            this.sendError(resp, e);
        }
        catch (UnknowPathException e) {
            this.sendError(resp, new HTTPError(400, RESTServiceConsumer.getName(context.getMethod()) + " - " + context.getLocation(), null));
        }
    }

    public void sendError(RESTResponse resp, HTTPError error) {
        try {
            resp.setStatus(error.getCode());
            resp.setContentType("text/plain");
            if (error.getBody() != null) {
                resp.getOutputStream().write(error.getBody().getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            error.printStackTrace();
        }
    }
}

