/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest.binding.internal;

import com.ibm.rules.res.model.rest.binding.internal.BindingLocalization;
import com.ibm.rules.res.model.rest.binding.internal.RESTServiceBindingBase;
import com.ibm.rules.res.util.internal.StreamUtil;
import com.ibm.rules.rest.Converter;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTContext;
import com.ibm.rules.rest.RESTServiceConsumer;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class RESTServiceJSONBinding
extends RESTServiceBindingBase {
    public static final String TYPE = "json";
    public static final String MEDIA_TYPE = "application/json";

    public RESTServiceJSONBinding(RESTServiceConsumer service) {
        super(service);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getMediaType() {
        return MEDIA_TYPE;
    }

    @Override
    public Converter getReader() {
        return new JSONConverter();
    }

    public static class JSONConverter
    implements Converter {
        private final ObjectMapper mapperIso8601 = new ObjectMapper();
        private final ObjectMapper mapperLong = new ObjectMapper();

        public JSONConverter() {
            this.mapperIso8601.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
            this.mapperIso8601.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
            this.mapperIso8601.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
            this.mapperLong.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
            this.mapperIso8601.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.mapperLong.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.mapperIso8601.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            this.mapperLong.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        }

        @Override
        public <T> T toObject(Class<T> clazz, byte[] data, RESTContext context) {
            try {
                ObjectMapper mapper = null;
                mapper = context.isIso8601dateFormat() ? this.mapperIso8601 : this.mapperLong;
                try {
                    return (T)mapper.readValue(StreamUtil.toStream(data), clazz);
                }
                catch (JsonParseException e) {
                    throw new HTTPError(400, "", BindingLocalization.getLocalizedMessage(context.getLocale(), BindingLocalization.NOT_CORRECT_SYNTAX_ERROR, RESTContext.Format.JSON.toString(), "[" + e.getLocation().getLineNr() + ", " + e.getLocation().getColumnNr() + "] " + e.getMessage()));
                }
                catch (Exception e) {
                    throw new HTTPError(400, "", BindingLocalization.getLocalizedMessage(context.getLocale(), BindingLocalization.NOT_CORRECT_SYNTAX_ERROR, RESTContext.Format.JSON.toString(), e.getMessage()));
                }
            }
            catch (Exception e) {
                throw new HTTPError(500, e);
            }
        }

        @Override
        public void toFormat(Writer writer, Object result, RESTContext context) {
            try {
                if (context.isIso8601dateFormat()) {
                    String stringValue = this.mapperIso8601.writeValueAsString(result);
                    writer.append(stringValue);
                } else {
                    this.mapperLong.writeValue(writer, result);
                }
            }
            catch (Exception e) {
                throw new HTTPError(500, e);
            }
        }

        @Override
        public RESTContext.Format getFormat() {
            return RESTContext.Format.JSON;
        }

        @Override
        public String getContentType() {
            return RESTServiceJSONBinding.MEDIA_TYPE;
        }
    }
}

