/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest.binding.internal;

import com.ibm.rules.res.model.rest.binding.internal.BindingLocalization;
import com.ibm.rules.res.model.rest.binding.internal.RESTServiceBindingBase;
import com.ibm.rules.res.util.internal.StreamUtil;
import com.ibm.rules.res.xml.internal.JAXBContext;
import com.ibm.rules.rest.Converter;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTContext;
import com.ibm.rules.rest.RESTServiceConsumer;
import com.ibm.rules.rest.RESTXmlAdapter;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RESTServiceXMLBinding
extends RESTServiceBindingBase {
    public static final String TYPE = "xml";
    public static final String MEDIA_TYPE = "application/xml";

    public RESTServiceXMLBinding(RESTServiceConsumer service) {
        super(service);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getMediaType() {
        return MEDIA_TYPE;
    }

    @Override
    public Converter getReader() {
        return new XMLConverter();
    }

    public class XMLConverter
    implements Converter {
        @Override
        public <T> T toObject(Class<T> clazz, byte[] data, RESTContext context) {
            JAXBContext jAXBContext = RESTServiceXMLBinding.this.jaxbContext;
            synchronized (jAXBContext) {
                try {
                    Unmarshaller unmarshaller = RESTServiceXMLBinding.this.jaxbContext.createUnmarshaller();
                    if (!context.isIso8601dateFormat()) {
                        unmarshaller.setAdapter(RESTXmlAdapter.class, (XmlAdapter)new RESTXmlAdapter(context.isIso8601dateFormat()));
                    }
                    try {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        try {
                            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document doc = db.parse(StreamUtil.toStream(data));
                        return (T)unmarshaller.unmarshal((Node)doc);
                    }
                    catch (Exception e) {
                        if (e instanceof UnmarshalException && ((UnmarshalException)e).getLinkedException() != null) {
                            throw new HTTPError(400, "", BindingLocalization.getLocalizedMessage(context.getLocale(), BindingLocalization.NOT_CORRECT_SYNTAX_ERROR, RESTContext.Format.XML.toString(), ((UnmarshalException)e).getLinkedException().getMessage()));
                        }
                        throw new HTTPError(400, "", BindingLocalization.getLocalizedMessage(context.getLocale(), BindingLocalization.NOT_CORRECT_SYNTAX_ERROR, RESTContext.Format.XML.toString(), e.getMessage()));
                    }
                }
                catch (JAXBException e) {
                    throw new HTTPError(500, (Exception)((Object)e));
                }
            }
        }

        @Override
        public RESTContext.Format getFormat() {
            return RESTContext.Format.XML;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toFormat(Writer writer, Object result, RESTContext context) {
            Marshaller marshaller = null;
            try {
                JAXBContext jAXBContext = RESTServiceXMLBinding.this.jaxbContext;
                synchronized (jAXBContext) {
                    marshaller = RESTServiceXMLBinding.this.jaxbContext.createMarshaller();
                }
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.setAdapter(RESTXmlAdapter.class, (XmlAdapter)new RESTXmlAdapter(context.isIso8601dateFormat()));
                marshaller.marshal(result, writer);
            }
            catch (Exception e) {
                throw new HTTPError(500, e);
            }
        }

        @Override
        public String getContentType() {
            return "text/xml";
        }
    }
}

