/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest.internal;

import com.ibm.rules.rest.Action;
import com.ibm.rules.rest.LocationStepChoicePoint;
import com.ibm.rules.rest.RESTServiceBinding;
import com.ibm.rules.rest.RESTServiceConsumer;
import com.ibm.rules.rest.RESTServiceDescriptionBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DOJOTreeBuilder
implements RESTServiceDescriptionBuilder {
    private LocationStepChoicePoint getChoicePoint;
    private LocationStepChoicePoint putChoicePoint;
    private LocationStepChoicePoint deleteChoicePoint;
    private LocationStepChoicePoint postChoicePoint;
    private final Map<String, RESTServiceBinding> context2binding;
    private final BindingBean bindingBean;

    public DOJOTreeBuilder(BindingBean bindingBean, Map<String, RESTServiceBinding> context2binding) {
        this.context2binding = context2binding;
        this.bindingBean = bindingBean;
    }

    @Override
    public Object getDescription(Locale locale) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String label = "name";
        String identifier = "path";
        result.put("label", label);
        result.put("identifier", identifier);
        ArrayList items = new ArrayList();
        for (Map.Entry<String, RESTServiceBinding> entry : this.context2binding.entrySet()) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put(label, entry.getKey());
            item.put(identifier, entry.getKey());
            item.put("type", "content-type");
            item.put("children", this.getDojoItemFileReadStore(locale, label, identifier, entry.getKey(), items));
            items.add(item);
            if (this.bindingBean == null) continue;
            this.bindingBean.addBinding(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, RESTServiceBinding> entry : items) {
            Map map = (Map)((Object)entry);
            if (!"action".equals(map.get("type"))) continue;
            Action action = (Action)map.remove("action");
            if (this.bindingBean == null) continue;
            this.bindingBean.addAction((String)map.get(identifier), action);
        }
        result.put("items", items);
        return result;
    }

    public List getDojoItemFileReadStore(Locale locale, String label, String identifier, String type, List refs) {
        ArrayList result = new ArrayList();
        LinkedHashMap<String, Object> get = new LinkedHashMap<String, Object>();
        get.put(label, RESTServiceConsumer.getName((short)1));
        String path = RESTServiceConsumer.getName((short)1) + ": " + type;
        get.put(identifier, path);
        get.put("type", "method");
        get.put("children", this.getDojoItemFileReadStore(this.getChoicePoint, locale, label, identifier, type, path, refs));
        result.add(get);
        LinkedHashMap<String, Object> post = new LinkedHashMap<String, Object>();
        post.put(label, RESTServiceConsumer.getName((short)4));
        path = RESTServiceConsumer.getName((short)4) + ": " + type;
        post.put(identifier, path);
        post.put("type", "method");
        post.put("children", this.getDojoItemFileReadStore(this.postChoicePoint, locale, label, identifier, type, path, refs));
        result.add(post);
        LinkedHashMap<String, Object> put = new LinkedHashMap<String, Object>();
        put.put(label, RESTServiceConsumer.getName((short)2));
        path = RESTServiceConsumer.getName((short)2) + ": " + type;
        put.put("type", "method");
        put.put(identifier, path);
        put.put("children", this.getDojoItemFileReadStore(this.putChoicePoint, locale, label, identifier, type, path, refs));
        result.add(put);
        LinkedHashMap<String, Object> delete = new LinkedHashMap<String, Object>();
        delete.put(label, RESTServiceConsumer.getName((short)8));
        path = RESTServiceConsumer.getName((short)8) + ": " + type;
        delete.put("type", "method");
        delete.put(identifier, path);
        delete.put("children", this.getDojoItemFileReadStore(this.deleteChoicePoint, locale, label, identifier, type, path, refs));
        result.add(delete);
        return result;
    }

    public List getDojoItemFileReadStore(LocationStepChoicePoint choicePoint, Locale locale, String label, String identifier, String type, String path, List<Map> refs) {
        String nextPath;
        LinkedHashMap<String, Object> next;
        ArrayList result = new ArrayList();
        if (choicePoint.getAction(null) != null) {
            boolean alreadyInRefs = false;
            String actionId = type + "#" + choicePoint.getAction(null).toString();
            for (Map tmpMap : refs) {
                if (!tmpMap.get(identifier).equals(actionId)) continue;
                alreadyInRefs = true;
                break;
            }
            if (!alreadyInRefs) {
                LinkedHashMap<String, Object> actionDesc = new LinkedHashMap<String, Object>();
                actionDesc.put(label, this.displayAction(choicePoint.getAction(null)));
                actionDesc.put(identifier, actionId);
                actionDesc.put("rest-url", path);
                actionDesc.put("type", "action");
                actionDesc.put("action", choicePoint.getAction(null));
                refs.add(actionDesc);
            }
            LinkedHashMap<String, String> actionRef = new LinkedHashMap<String, String>();
            actionRef.put("_reference", actionId);
            result.add(actionRef);
        }
        if (choicePoint.getSteps() != null) {
            for (Map.Entry<String, LocationStepChoicePoint> entry : choicePoint.getSteps().entrySet()) {
                next = new LinkedHashMap<String, Object>();
                nextPath = path + "/" + entry.getKey();
                next.put(label, entry.getKey());
                next.put(identifier, nextPath);
                next.put("children", this.getDojoItemFileReadStore(entry.getValue(), locale, label, identifier, type, nextPath, refs));
                result.add(next);
            }
        }
        if (choicePoint.getWildNames() != null) {
            for (LocationStepChoicePoint.WildName wildName : choicePoint.getWildNames()) {
                next = new LinkedHashMap();
                nextPath = path + "/" + "{" + wildName.name + "}";
                next.put(label, "{" + wildName.name + "}");
                next.put(identifier, nextPath);
                if (wildName.regexp != null) {
                    next.put("regexp", wildName.regexp);
                    next.put("type", "variable-regexp");
                } else {
                    next.put("type", "variable");
                }
                if (wildName.step != null) {
                    next.put("children", this.getDojoItemFileReadStore(wildName.step, locale, label, identifier, type, nextPath, refs));
                } else {
                    next.put("children", this.getDojoItemFileReadStore(choicePoint.getWildNameStep(), locale, label, identifier, type, nextPath, refs));
                }
                result.add(next);
            }
        }
        return result;
    }

    private Object displayAction(Action action) {
        StringBuffer result = new StringBuffer();
        result.append(action.getPublicName()).append('(');
        this.displayParameters(result, action.getParameters());
        result.append(')');
        return result.toString();
    }

    public void displayParameters(StringBuffer result, List<Action.Parameter> params) {
        if (params == null) {
            return;
        }
        boolean first = true;
        for (Action.Parameter param : params) {
            if (!first) {
                result.append("},{");
            } else {
                result.append('{');
            }
            result.append(param.name);
            first = false;
        }
        result.append('}');
    }

    @Override
    public void putMethod(short method, LocationStepChoicePoint choicePoint) {
        switch (method) {
            case 4: {
                this.postChoicePoint = choicePoint;
                break;
            }
            case 2: {
                this.putChoicePoint = choicePoint;
                break;
            }
            case 8: {
                this.deleteChoicePoint = choicePoint;
                break;
            }
            default: {
                this.getChoicePoint = choicePoint;
            }
        }
    }

    public static interface BindingBean {
        public void addBinding(String var1, RESTServiceBinding var2);

        public void addAction(String var1, Action var2);
    }
}

