/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.notificationserver;

import com.ibm.rules.res.notificationserver.NotificationHandler;
import com.ibm.rules.res.notificationserver.internal.DefaultNotificationServerClient;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;

public class NotificationServerClientFactory {
    private static NotificationServerClientFactory _instance = new NotificationServerClientFactory();

    private NotificationServerClientFactory() {
    }

    public static NotificationServerClientFactory getInstance() {
        return _instance;
    }

    public DefaultNotificationServerClient createNotificationServerClient(String theClientID, URI theNotificationServerURI, NotificationHandler theNotificationHandler, long theReconnectionDelayInMilliseconds, Logger theLogger) {
        return new DefaultNotificationServerClient(theClientID, null, theNotificationServerURI.getHost(), theNotificationServerURI.getPort(), theNotificationHandler, theReconnectionDelayInMilliseconds, theLogger, -1L);
    }

    public DefaultNotificationServerClient createNotificationServerClient(String theClientID, URI theNotificationServerURI, NotificationHandler theNotificationHandler, long theReconnectionDelayInMilliseconds, Logger theLogger, ThreadFactory theCustomThreadFactory) {
        return new DefaultNotificationServerClient(theClientID, null, theNotificationServerURI.getHost(), theNotificationServerURI.getPort(), theNotificationHandler, theReconnectionDelayInMilliseconds, theLogger, theCustomThreadFactory, -1L);
    }

    public DefaultNotificationServerClient createNotificationServerClient(String theClientID, Properties theClientProperties, URI theNotificationServerURI, NotificationHandler theNotificationHandler, long theReconnectionDelayInMilliseconds, Logger theLogger) {
        return new DefaultNotificationServerClient(theClientID, theClientProperties, theNotificationServerURI.getHost(), theNotificationServerURI.getPort(), theNotificationHandler, theReconnectionDelayInMilliseconds, theLogger, null, -1L);
    }

    public DefaultNotificationServerClient createNotificationServerClient(String theClientID, Properties theClientProperties, URI theNotificationServerURI, NotificationHandler theNotificationHandler, long theReconnectionDelayInMilliseconds, Logger theLogger, ThreadFactory theCustomThreadFactory) {
        if (theReconnectionDelayInMilliseconds < 0L || theLogger == null || theClientID == null || theNotificationServerURI != null && !"ns".equals(theNotificationServerURI.getScheme())) {
            throw new IllegalArgumentException();
        }
        return new DefaultNotificationServerClient(theClientID, theClientProperties, theNotificationServerURI.getHost(), theNotificationServerURI.getPort(), theNotificationHandler, theReconnectionDelayInMilliseconds, theLogger, theCustomThreadFactory, -1L);
    }

    public DefaultNotificationServerClient createNotificationServerClient(String theClientID, Properties theClientProperties, URI theNotificationServerURI, NotificationHandler theNotificationHandler, long theReconnectionDelayInMilliseconds, Logger theLogger, ThreadFactory theCustomThreadFactory, long connectTimeoutInMillis) {
        if (theReconnectionDelayInMilliseconds < 0L || theLogger == null || theClientID == null || theNotificationServerURI != null && !"ns".equals(theNotificationServerURI.getScheme())) {
            throw new IllegalArgumentException();
        }
        return new DefaultNotificationServerClient(theClientID, theClientProperties, theNotificationServerURI.getHost(), theNotificationServerURI.getPort(), theNotificationHandler, theReconnectionDelayInMilliseconds, theLogger, theCustomThreadFactory, connectTimeoutInMillis);
    }
}

