/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.notificationserver.internal;

import com.ibm.rules.res.message.internal.XXNotificationServerMessageCode;
import com.ibm.rules.res.notificationserver.Message;
import com.ibm.rules.res.notificationserver.NotificationServer;
import com.ibm.rules.res.notificationserver.NotificationServerClientInformation;
import com.ibm.rules.res.notificationserver.internal.DefaultMessage;
import com.ibm.rules.res.notificationserver.internal.KeepAlive;
import com.ibm.rules.res.notificationserver.internal.ServerConnectionHandler;
import com.ibm.rules.res.notificationserver.internal.util.IoSessionHelper;
import com.ibm.rules.res.notificationserver.internal.util.LogMessageHelper;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class DefaultNotificationServer
implements NotificationServer {
    private int portNumber = 1889;
    private IoAcceptor acceptor = null;
    private ServerConnectionHandler connectionHandler = null;
    private Logger logger = null;

    public DefaultNotificationServer(int thePortNumber, Logger theLogger) {
        if (thePortNumber < 1) {
            throw new IllegalArgumentException(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.SEVERE_SERVER_PORT_MUST_BE_GREATER_THAN_ZERO, new String[]{String.valueOf(thePortNumber)}));
        }
        if (theLogger == null) {
            throw new IllegalArgumentException();
        }
        this.portNumber = thePortNumber;
        this.logger = theLogger;
        this.connectionHandler = new ServerConnectionHandler(theLogger);
    }

    @Override
    public void start() throws IOException {
        if (this.acceptor != null) {
            if (this.acceptor.isActive()) {
                throw new IllegalStateException(LogMessageHelper.getMessage(this, XXNotificationServerMessageCode.SEVERE_SERVER_ALREADY_RUNNING));
            }
            if (!this.acceptor.isDisposing() && !this.acceptor.isDisposed()) {
                this.acceptor.unbind();
                this.acceptor.dispose(false);
            }
        }
        this.acceptor = new NioSocketAcceptor();
        ((NioSocketAcceptor)this.acceptor).setReuseAddress(true);
        this.acceptor.addListener(new IoServiceListener(){

            public void sessionDestroyed(IoSession arg0) throws Exception {
            }

            public void sessionCreated(IoSession arg0) throws Exception {
            }

            public void serviceIdle(IoService arg0, IdleStatus arg1) throws Exception {
            }

            public void serviceDeactivated(IoService arg0) throws Exception {
                if (DefaultNotificationServer.this.logger.isLoggable(Level.INFO)) {
                    DefaultNotificationServer.this.logger.info(LogMessageHelper.getMessage(this, XXNotificationServerMessageCode.INFO_SERVER_STOPPED));
                }
            }

            public void serviceActivated(IoService arg0) throws Exception {
                if (DefaultNotificationServer.this.logger.isLoggable(Level.INFO)) {
                    DefaultNotificationServer.this.logger.info(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_SERVER_STARTED, new String[]{String.valueOf(DefaultNotificationServer.this.portNumber)}));
                }
            }
        });
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        KeepAlive.keepAliveFilterForServer(this.acceptor, this.logger);
        this.acceptor.setHandler((IoHandler)this.connectionHandler);
        this.acceptor.getSessionConfig().setReadBufferSize(8192);
        this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
        this.acceptor.getSessionConfig().setWriteTimeout(2);
        this.acceptor.setCloseOnDeactivation(true);
        try {
            this.acceptor.bind((SocketAddress)new InetSocketAddress(this.portNumber));
        }
        catch (IOException e) {
            this.acceptor = null;
            throw e;
        }
    }

    @Override
    public void stop() {
        if (this.acceptor != null && this.acceptor.isActive()) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info(LogMessageHelper.getMessage(this, XXNotificationServerMessageCode.INFO_SERVER_STOPPING));
            }
            this.acceptor.unbind();
            this.acceptor.dispose(false);
        }
    }

    @Override
    public boolean isStopped() {
        return this.acceptor == null || this.acceptor.isDisposed();
    }

    @Override
    public Collection<NotificationServerClientInformation> getClientsInformations() {
        return this.connectionHandler.getClientsInformation();
    }

    @Override
    public NotificationServerClientInformation getClientInformations(String theClientID) {
        return this.connectionHandler.getClientInformations(theClientID);
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public void broadcastNotification(Message theNotification) throws IOException, JAXBException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_SERVER_BROADCASTING_NOTIFICATION, new String[]{String.valueOf(theNotification.getHeader())}));
        }
        this.acceptor.broadcast((Object)DefaultMessage.serialize(theNotification));
    }

    @Override
    public Serializable sendRequest(final String theClientID, final Message theRequest, int theTimeoutInSeconds) throws IOException, TimeoutException, JAXBException {
        IoSession clientSession;
        if (theClientID == null || theRequest == null) {
            throw new IllegalArgumentException();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_SERVER_SENDING_REQUEST, new String[]{String.valueOf(theRequest.getHeader()), theClientID}));
        }
        if ((clientSession = this.connectionHandler.getClientSession(theClientID)) == null) {
            throw new IOException(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.SEVERE_SERVER_CLIENT_NOT_CONNECTED, new String[]{theClientID}));
        }
        this.connectionHandler.addResponseMonitor(theRequest.getID());
        WriteFuture future = clientSession.write((Object)DefaultMessage.serialize(theRequest));
        future.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

            public void operationComplete(WriteFuture future) {
                if (!future.isWritten() && DefaultNotificationServer.this.logger.isLoggable(Level.SEVERE)) {
                    DefaultNotificationServer.this.logger.log(Level.SEVERE, LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.SEVERE_ERROR_OCCURED_WHEN_SERVER_SENT_REQUEST, new String[]{IoSessionHelper.toString(clientSession), String.valueOf(theRequest.getHeader()), theClientID}), future.getException());
                }
            }
        });
        return this.connectionHandler.getResponse(theRequest.getID(), theTimeoutInSeconds);
    }
}

