/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.notificationserver.internal;

import com.ibm.rules.res.message.internal.XXNotificationServerMessageCode;
import com.ibm.rules.res.notificationserver.Message;
import com.ibm.rules.res.notificationserver.NotificationHandler;
import com.ibm.rules.res.notificationserver.NotificationServerClient;
import com.ibm.rules.res.notificationserver.internal.ClientConnectionHandler;
import com.ibm.rules.res.notificationserver.internal.KeepAlive;
import com.ibm.rules.res.notificationserver.internal.util.IoSessionHelper;
import com.ibm.rules.res.notificationserver.internal.util.LogMessageHelper;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class DefaultNotificationServerClient
implements NotificationServerClient {
    private String id = null;
    private Properties properties = null;
    private String notificationServerHost = null;
    private int notificationServerPort = 0;
    private IoConnector connector = null;
    private IoSession currentSession = null;
    private State state = State.DISCONNECTED;
    private NotificationHandler notificationHandler = null;
    private Logger logger = null;
    private long reconnectionDelayInMilliseconds = 0L;
    private LoopConnectFutureListener loopConnectFutureListener = null;
    private ThreadFactory customThreadFactory = null;
    private long connectTimeoutInMillis = -1L;
    private Boolean disconnectionRequested = Boolean.FALSE;

    public DefaultNotificationServerClient(String theID, Properties theProperties, String theNotificationServerHost, int theNotificationServerPort, NotificationHandler theNotificationHandler, long theReconnectionDelayInMilliseconds, Logger theLogger, long connectTimeoutInMillis) {
        this(theID, theProperties, theNotificationServerHost, theNotificationServerPort, theNotificationHandler, theReconnectionDelayInMilliseconds, theLogger, null, connectTimeoutInMillis);
    }

    public DefaultNotificationServerClient(String theID, Properties theProperties, String theNotificationServerHost, int theNotificationServerPort, NotificationHandler theNotificationHandler, long theReconnectionDelayInMilliseconds, Logger theLogger, ThreadFactory theThreadFactory, long connectTimeoutInMillis) {
        if (theReconnectionDelayInMilliseconds < 0L || theLogger == null) {
            throw new IllegalArgumentException();
        }
        this.id = theID;
        this.properties = theProperties;
        this.notificationServerHost = theNotificationServerHost;
        this.notificationServerPort = theNotificationServerPort;
        this.notificationHandler = theNotificationHandler;
        this.logger = theLogger;
        this.reconnectionDelayInMilliseconds = theReconnectionDelayInMilliseconds;
        this.loopConnectFutureListener = new LoopConnectFutureListener(this);
        this.customThreadFactory = theThreadFactory;
        this.connectTimeoutInMillis = connectTimeoutInMillis;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void connect() {
        if (this.connector != null && this.connector.isActive()) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_ALREADY_CONNECTED, new String[]{this.id}));
            }
            return;
        }
        this.cancelAnyDisconnectionRequest();
        this.loopConnect();
    }

    @Override
    public void disconnect() {
        this.requestDisconnection();
        if (this.connector != null) {
            this.state = State.DISCONNECTING;
            for (IoSession session : this.connector.getManagedSessions().values()) {
                session.close(false);
            }
            this.connector.dispose(false);
            this.state = State.DISCONNECTED;
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_DISCONNECTED_FROM_SERVER, new String[]{this.id}));
            }
        }
    }

    @Override
    public boolean isConnecting() {
        return State.CONNECTING.equals((Object)this.state);
    }

    @Override
    public boolean isConnected() {
        return State.CONNECTED.equals((Object)this.state);
    }

    @Override
    public boolean isDisconnecting() {
        return State.DISCONNECTING.equals((Object)this.state);
    }

    @Override
    public boolean isDisconnected() {
        return State.DISCONNECTED.equals((Object)this.state);
    }

    @Override
    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public void sendMessage(Message theMessage) {
        if (this.connector == null || !this.connector.isActive()) {
            throw new IllegalStateException();
        }
        WriteFuture future = this.currentSession.write((Object)theMessage);
        future.awaitUninterruptibly();
    }

    public void onUnexpectedDisconnection(IoSession theSession) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.WARNING_CLIENT_UNEXPECTED_DISCONNECTION, new String[]{IoSessionHelper.toString(theSession), this.id}));
        }
        this.loopConnect();
    }

    private ConnectFuture loopConnect() {
        ConnectFuture returnedValue = null;
        this.state = State.CONNECTING;
        while (returnedValue == null || !returnedValue.isConnected()) {
            if (!this.disconnectionRequested.booleanValue()) {
                returnedValue = this.connect(this.loopConnectFutureListener);
                if (returnedValue != null && returnedValue.isConnected()) continue;
                try {
                    Thread.sleep(this.reconnectionDelayInMilliseconds);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return null;
        }
        return returnedValue;
    }

    private ConnectFuture connect(LoopConnectFutureListener theConnectFutureListener) {
        try {
            if (this.connector == null || this.connector.isDisposing() || this.connector.isDisposed()) {
                ClassLoader cl;
                this.connector = new NioSocketConnector();
                this.connector.setDefaultRemoteAddress((SocketAddress)new InetSocketAddress(this.notificationServerHost, this.notificationServerPort));
                if (this.customThreadFactory != null) {
                    ExecutorFilter executorFilter = new ExecutorFilter();
                    ((ThreadPoolExecutor)executorFilter.getExecutor()).setThreadFactory(this.customThreadFactory);
                    this.connector.getFilterChain().addFirst("threadManagement", (IoFilter)executorFilter);
                }
                if ((cl = this.getClass().getClassLoader()) != null) {
                    this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory(cl)));
                } else {
                    this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
                }
                KeepAlive.keepAliveFilterForClient(this.connector, this.logger);
                this.connector.setHandler((IoHandler)new ClientConnectionHandler(this, this.logger));
                this.connector.getSessionConfig().setReadBufferSize(8192);
                this.connector.getSessionConfig().setWriteTimeout(2);
                if (this.connectTimeoutInMillis > 0L) {
                    this.connector.setConnectTimeoutMillis(this.connectTimeoutInMillis);
                }
                this.connector.addListener(new IoServiceListener(){

                    public void sessionDestroyed(IoSession arg0) throws Exception {
                    }

                    public void sessionCreated(IoSession arg0) throws Exception {
                    }

                    public void serviceIdle(IoService arg0, IdleStatus arg1) throws Exception {
                    }

                    public void serviceDeactivated(IoService arg0) throws Exception {
                        if (DefaultNotificationServerClient.this.logger.isLoggable(Level.FINEST)) {
                            DefaultNotificationServerClient.this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_DISCONNECTED_FROM_SERVER, new String[]{DefaultNotificationServerClient.this.id}));
                        }
                    }

                    public void serviceActivated(IoService arg0) throws Exception {
                        if (DefaultNotificationServerClient.this.logger.isLoggable(Level.INFO)) {
                            DefaultNotificationServerClient.this.logger.info(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_CONNECTED_TO_SERVER, new String[]{DefaultNotificationServerClient.this.id, DefaultNotificationServerClient.this.notificationServerHost, String.valueOf(DefaultNotificationServerClient.this.notificationServerPort)}));
                        }
                    }
                });
            }
        }
        catch (RuntimeException re) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.WARNING_CLIENT_SOCKET_CREATION_ERROR, new String[]{this.id}), re);
            }
            return null;
        }
        this.state = State.CONNECTING;
        ConnectFuture future = this.connector.connect();
        future.addListener((IoFutureListener)theConnectFutureListener);
        return future;
    }

    public void requestDisconnection() {
        this.disconnectionRequested = Boolean.TRUE;
    }

    public void cancelAnyDisconnectionRequest() {
        this.disconnectionRequested = Boolean.FALSE;
    }

    public class LoopConnectFutureListener
    implements IoFutureListener<ConnectFuture> {
        private DefaultNotificationServerClient client = null;
        private boolean isLoggableConnection = true;

        public LoopConnectFutureListener(DefaultNotificationServerClient theClient) {
            if (theClient == null) {
                throw new IllegalArgumentException();
            }
            this.client = theClient;
        }

        public void operationComplete(ConnectFuture future) {
            if (future.isConnected()) {
                DefaultNotificationServerClient.this.currentSession = future.getSession();
                DefaultNotificationServerClient.this.state = State.CONNECTED;
                this.isLoggableConnection = true;
                if (DefaultNotificationServerClient.this.disconnectionRequested.booleanValue()) {
                    DefaultNotificationServerClient.this.disconnect();
                }
            } else {
                DefaultNotificationServerClient.this.state = State.DISCONNECTED;
                if (DefaultNotificationServerClient.this.disconnectionRequested.booleanValue()) {
                    if (DefaultNotificationServerClient.this.connector != null && !DefaultNotificationServerClient.this.connector.isDisposing() && !DefaultNotificationServerClient.this.connector.isDisposed()) {
                        DefaultNotificationServerClient.this.connector.dispose(false);
                    }
                    return;
                }
                Level level = this.isLoggableConnection ? Level.WARNING : Level.FINEST;
                if (DefaultNotificationServerClient.this.logger.isLoggable(level)) {
                    if (!this.isLoggableConnection) {
                        DefaultNotificationServerClient.this.logger.log(new LogRecord(Level.FINEST, LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_FAILED_TO_CONNECT_TO_SERVER, new String[]{this.client.getID(), String.valueOf(DefaultNotificationServerClient.this.reconnectionDelayInMilliseconds), future.getException().toString()})));
                    } else {
                        DefaultNotificationServerClient.this.logger.warning(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_FAILED_TO_CONNECT_TO_SERVER, new String[]{this.client.getID(), String.valueOf(DefaultNotificationServerClient.this.reconnectionDelayInMilliseconds), future.getException().toString()}));
                        this.isLoggableConnection = false;
                    }
                }
            }
        }
    }

    public static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

