/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.notificationserver.internal;

import com.ibm.rules.res.message.internal.XXNotificationServerMessageCode;
import com.ibm.rules.res.notificationserver.internal.util.LogMessageHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.keepalive.KeepAliveFilter;
import org.apache.mina.filter.keepalive.KeepAliveMessageFactory;
import org.apache.mina.filter.keepalive.KeepAliveRequestTimeoutHandler;
import org.apache.mina.transport.socket.SocketSessionConfig;

public class KeepAlive {
    static final String PING = "ping";
    static final String PONG = "pong";
    private static final int INTERVAL = 60;
    private static final int TIMEOUT = 30;

    public static void keepAliveFilterForServer(IoAcceptor acceptor, Logger logger) {
        KeepAliveFilter filter = new KeepAliveFilter((KeepAliveMessageFactory)new ServerFactory(), IdleStatus.BOTH_IDLE, KeepAliveRequestTimeoutHandler.CLOSE, 60, 30);
        filter.setRequestTimeoutHandler((KeepAliveRequestTimeoutHandler)new keepAliveRequestTimedOutLogger(logger));
        acceptor.getFilterChain().addAfter("codec", "keep-alive", (IoFilter)filter);
    }

    public static void keepAliveFilterForClient(IoConnector connector, Logger logger) {
        KeepAliveFilter filter = new KeepAliveFilter((KeepAliveMessageFactory)new ClientFactory(), IdleStatus.BOTH_IDLE, KeepAliveRequestTimeoutHandler.CLOSE, 60, 30);
        filter.setForwardEvent(true);
        filter.setRequestTimeoutHandler((KeepAliveRequestTimeoutHandler)new keepAliveRequestTimedOutLogger(logger));
        ((SocketSessionConfig)connector.getSessionConfig()).setKeepAlive(true);
        connector.getFilterChain().addAfter("codec", "keep-alive", (IoFilter)filter);
    }

    static boolean checkRequest(String message) {
        if (message != null) {
            return message.equals(PING);
        }
        return false;
    }

    static boolean checkResponse(String message) {
        if (message != null) {
            return message.equals(PONG);
        }
        return false;
    }

    public static final class ClientFactory
    implements KeepAliveMessageFactory {
        public Object getRequest(IoSession session) {
            return KeepAlive.PING;
        }

        public Object getResponse(IoSession session, Object request) {
            return KeepAlive.PONG;
        }

        public boolean isRequest(IoSession session, Object message) {
            if (message instanceof String) {
                return KeepAlive.checkRequest((String)message);
            }
            return false;
        }

        public boolean isResponse(IoSession session, Object message) {
            if (message instanceof String) {
                return KeepAlive.checkResponse((String)message);
            }
            return false;
        }
    }

    private static class keepAliveRequestTimedOutLogger
    implements KeepAliveRequestTimeoutHandler {
        Logger logger;

        keepAliveRequestTimedOutLogger(Logger logger) {
            this.logger = logger;
        }

        public void keepAliveRequestTimedOut(KeepAliveFilter paramKeepAliveFilter, IoSession paramIoSession) throws Exception {
            if (this.logger != null && this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_KEEPALIVE_ERROR, new String[]{Integer.valueOf(paramKeepAliveFilter.getRequestTimeout()).toString()}));
            }
            paramIoSession.close();
        }
    }

    public static final class ServerFactory
    implements KeepAliveMessageFactory {
        public Object getRequest(IoSession session) {
            return KeepAlive.PING;
        }

        public Object getResponse(IoSession session, Object request) {
            return KeepAlive.PONG;
        }

        public boolean isRequest(IoSession session, Object message) {
            if (message instanceof String) {
                return KeepAlive.checkRequest((String)message);
            }
            return false;
        }

        public boolean isResponse(IoSession session, Object message) {
            if (message instanceof String) {
                return KeepAlive.checkResponse((String)message);
            }
            return false;
        }
    }
}

