/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence;

import com.ibm.rules.res.model.MutableXOMLibraryInformation;
import com.ibm.rules.res.model.XOMLibraryId;
import com.ibm.rules.res.model.XOMRepositoryFactory;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.DiagnosticResult;
import com.ibm.rules.res.persistence.Transaction;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.persistence.IlrResourceNotFoundDAOException;
import java.io.InputStream;
import java.util.Set;

public interface XOMRepositoryDAO {
    public Transaction beginTransaction() throws DAOException;

    public Set<XOMResourceId> loadResources() throws DAOException;

    public Set<XOMResourceId> loadResources(String var1) throws DAOException;

    public String getDetails();

    public DiagnosticResult executeDiagnostic();

    public Set<XOMLibraryId> isReferenced(String var1) throws DAOException;

    public XOMResourceId isAvailable(String var1, byte[] var2) throws DAOException, IlrResourceNotFoundDAOException;

    public XOMResourceId isAvailable(String var1, IlrVersion var2) throws DAOException, IlrResourceNotFoundDAOException;

    public XOMResourceId getResourceInformation(String var1, IlrVersion var2) throws DAOException, IlrResourceNotFoundDAOException;

    public XOMLibraryId getLibraryInformation(String var1, IlrVersion var2) throws DAOException, IlrResourceNotFoundDAOException;

    public XOMResourceId addResource(String var1, IlrVersion var2, InputStream var3) throws DAOException, IlrResourceNotFoundDAOException;

    public XOMResourceId addResource(String var1, IlrVersion var2, InputStream var3, Transaction var4) throws DAOException, IlrResourceNotFoundDAOException;

    public boolean removeResource(XOMResourceId var1) throws DAOException, IlrResourceNotFoundDAOException;

    public boolean removeResource(XOMResourceId var1, Transaction var2) throws DAOException, IlrResourceNotFoundDAOException;

    public byte[] getContent(XOMResourceId var1) throws DAOException, IlrResourceNotFoundDAOException;

    public Set<XOMLibraryId> loadLibraries() throws DAOException;

    public Set<MutableXOMLibraryInformation> loadLibraries(XOMRepositoryFactory var1) throws DAOException;

    public Set<XOMLibraryId> loadLibraries(String var1) throws DAOException;

    public String[] getContent(XOMLibraryId var1) throws DAOException;

    public XOMLibraryId addLibrary(String var1, IlrVersion var2, String[] var3) throws DAOException, IlrResourceNotFoundDAOException;

    public XOMLibraryId addLibrary(String var1, IlrVersion var2, String[] var3, Transaction var4) throws DAOException, IlrResourceNotFoundDAOException;

    public boolean removeLibrary(XOMLibraryId var1) throws DAOException, IlrResourceNotFoundDAOException;

    public boolean removeLibrary(XOMLibraryId var1, Transaction var2) throws DAOException, IlrResourceNotFoundDAOException;
}

