/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal;

import com.ibm.rules.res.model.XOMLibraryId;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import java.util.Set;

public class XOMLibraryDeployer {
    private static final String BUNDLE = "ilog.rules.res.persistence.impl.messages";

    public XOMLibraryId deploy(XOMRepositoryDAO repository, String[] resources, String name, String mergingPolicy, boolean major) throws IlrFormatException {
        XOMLibraryId customerLibrary = XOMInternalNameUtil.getXOMLibraryId(name);
        if ("INCREMENT_MERGING_POLICY".equals(mergingPolicy)) {
            return this.addAtEndLibrary(repository, resources, customerLibrary, major);
        }
        if ("REPLACE_LATEST_MERGING_POLICY".equals(mergingPolicy)) {
            return this.replaceLatestLibrary(repository, resources, customerLibrary);
        }
        throw new IlrIllegalArgumentRuntimeException(BUNDLE, IlrDAOLocalization.ERROR_MERGING_POLICY_NOT_SUPPORTED, new String[]{mergingPolicy});
    }

    protected XOMLibraryId addAtEndLibrary(XOMRepositoryDAO repository, String[] resources, XOMLibraryId customerLibrary, boolean major) {
        Set<XOMLibraryId> libraries = null;
        try {
            libraries = repository.loadLibraries(customerLibrary.getName());
        }
        catch (DAOException e) {
            throw new IlrResourceRuntimeException(BUNDLE, IlrDAOLocalization.ERROR_LIBRARY_CREATION, e);
        }
        IlrVersion latestVersion = XOMInternalNameUtil.computeLibLastestVersion(libraries, null);
        IlrVersion newVersion = XOMInternalNameUtil.nextVersion(latestVersion, major);
        try {
            return repository.addLibrary(customerLibrary.getName(), newVersion, resources);
        }
        catch (Exception e) {
            throw new IlrResourceRuntimeException(BUNDLE, IlrDAOLocalization.ERROR_LIBRARY_CREATION, e);
        }
    }

    protected XOMLibraryId replaceLatestLibrary(XOMRepositoryDAO repository, String[] resources, XOMLibraryId customerLibrary) {
        try {
            IlrVersion version = customerLibrary.getVersion();
            if (version == null) {
                Set<XOMLibraryId> libraries = repository.loadLibraries(customerLibrary.getName());
                IlrVersion latestVersion = XOMInternalNameUtil.computeLibLastestVersion(libraries, null);
                version = latestVersion == null ? new IlrVersion(1, 0) : latestVersion;
            }
            return repository.addLibrary(customerLibrary.getName(), version, resources);
        }
        catch (Exception e) {
            throw new IlrResourceRuntimeException(BUNDLE, IlrDAOLocalization.ERROR_LIBRARY_CREATION, e);
        }
    }
}

