/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal;

import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrResourceRuntimeException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import java.io.InputStream;
import java.util.Set;

public class XOMResourceDeployer {
    private static final String BUNDLE = "ilog.rules.res.persistence.impl.messages";

    public XOMResourceId deploy(XOMRepositoryDAO repository, String name, InputStream data, boolean major) throws IlrFormatException {
        Set<XOMResourceId> resources = null;
        try {
            resources = repository.loadResources(name);
        }
        catch (DAOException e) {
            throw new IlrResourceRuntimeException(BUNDLE, IlrDAOLocalization.ERROR_LIBRARY_CREATION, e);
        }
        IlrVersion latestVersion = XOMInternalNameUtil.computeResLastestVersion(resources, null);
        IlrVersion newVersion = XOMInternalNameUtil.nextVersion(latestVersion, major);
        try {
            return repository.addResource(name, newVersion, data);
        }
        catch (Exception e) {
            throw new IlrResourceRuntimeException(BUNDLE, IlrDAOLocalization.ERROR_LIBRARY_CREATION, e);
        }
    }
}

