/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.jdbc;

import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.IlrResourceProviderDescriptorReader;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Map;

public class DAOConfigurator {
    public static final String REPOSITORY_DESCRIPTOR = "XOMRepositoryDAODescriptor.xml";
    private final IlrJDBCConnectionProvider connectionProvider;
    private final String daoClassName;
    private final Map<String, String> sqlStatements;
    private final Map<String, IlrResourceProviderDescriptorReader.Table> sqlTables;
    private final String url;
    private final String user;
    private final String databaseProductName;
    private final String databaseProductVersion;

    public DAOConfigurator(final String descriptor, IlrJDBCConnectionProvider connectionProvider) throws IlrDAOException {
        this.connectionProvider = connectionProvider;
        Connection conn = connectionProvider.getConnection();
        try {
            DatabaseMetaData metadata = conn.getMetaData();
            if (metadata == null) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.METADATA_UNAVAILABLE_ERROR);
            }
            this.databaseProductName = metadata.getDatabaseProductName();
            this.databaseProductVersion = metadata.getDatabaseProductVersion();
            this.url = metadata.getURL();
            this.user = metadata.getUserName();
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.METADATA_CONNECTION_ERROR, e);
        }
        finally {
            IlrDatabaseUtility.closeConnection(conn);
        }
        InputStream inputStream = null;
        try {
            inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    return this.getClass().getResourceAsStream(descriptor);
                }
            });
            IlrResourceProviderDescriptorReader descriptorReader = new IlrResourceProviderDescriptorReader(inputStream, this.databaseProductName);
            this.daoClassName = descriptorReader.getResourceProviderClassName();
            this.sqlStatements = descriptorReader.getSQLStatements();
            this.sqlTables = descriptorReader.getSQLTables();
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.XML_DESCRIPTOR_ERROR, new String[]{descriptor}, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Object createDAO() throws IlrDAOException {
        try {
            Class<?> resourceProviderClass = Class.forName(this.daoClassName);
            Constructor<?> resourceProviderConstructor = resourceProviderClass.getConstructor(this.getClass(), IlrJDBCConnectionProvider.class);
            return resourceProviderConstructor.newInstance(this, this.connectionProvider);
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.DAO_CREATION_ERROR, new String[]{this.daoClassName}, e);
        }
    }

    public String getSQLStatement(String key) {
        return this.sqlStatements.get(key);
    }

    public IlrResourceProviderDescriptorReader.Table getSQLTable(String key) {
        return this.sqlTables.get(key);
    }

    public String getDatabaseURL() {
        return this.url;
    }

    public String getUserName() {
        return this.user;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }
}

