/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.jdbc;

import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.internal.PersistencePropertiesConverter;
import com.ibm.rules.res.persistence.internal.jdbc.DAOConfigurator;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrDriverConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import java.sql.Driver;
import java.util.Properties;

public class DriverXOMDAOFactory {
    public static Object getDAO(String descriptor, ClassLoader classLoader, String driverName, String url, Properties connProps) throws DAOException {
        try {
            IlrJDBCConnectionProvider connectionProvider = DriverXOMDAOFactory.createJDBCConnectionProvider(classLoader, driverName, url, connProps);
            DAOConfigurator configurator = new DAOConfigurator(descriptor, connectionProvider);
            return configurator.createDAO();
        }
        catch (IlrDAOException e) {
            throw new DAOException(e);
        }
    }

    public static Object getDAO(String descriptor, IlrJDBCConnectionProvider connectionProvider) throws IlrDAOException {
        DAOConfigurator configurator = new DAOConfigurator(descriptor, connectionProvider);
        return configurator.createDAO();
    }

    public static IlrJDBCConnectionProvider createJDBCConnectionProvider(ClassLoader classLoader, String driverName, String url, Properties connProps) throws IlrDAOException {
        try {
            Class<?> driverClass = null;
            driverClass = classLoader != null ? Class.forName(driverName, true, classLoader) : Class.forName(driverName);
            Driver driver = (Driver)driverClass.newInstance();
            return new IlrDriverConnectionProvider(driver, url, connProps);
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.DRIVER_CREATION_ERROR, new String[]{String.valueOf(classLoader), driverName, url, String.valueOf(PersistencePropertiesConverter.obfuscate(connProps))}, e);
        }
    }
}

