/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.jdbc;

import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.DiagnosticResult;
import com.ibm.rules.res.persistence.internal.jdbc.DAOConfigurator;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public abstract class GenericDAOBase {
    private static final String SCHEMA_DB2 = "db2";
    private static final String SCHEMA_DB2_OS3980 = "db2_os390";
    private static final String SCHEMA_DERBY = "derby";
    private static final String SCHEMA_HSQLDB = "hsqldb";
    private static final String SCHEMA_H2 = "h2";
    private static final String SCHEMA_MYSQL = "mysql";
    private static final String SCHEMA_ORACLE = "oracle";
    private static final String SCHEMA_POINTBASE = "pointbase";
    private static final String SCHEMA_POSTGRESQL = "postgresql";
    private static final String SCHEMA_SQLSERVER = "sqlserver";
    private static final String SCHEMA_SYBASE = "sybase";
    protected final DAOConfigurator configurator;
    protected final IlrJDBCConnectionProvider connectionProvider;
    private final String schemaPrefix;

    public GenericDAOBase(DAOConfigurator configurator, IlrJDBCConnectionProvider connectionProvider, String schemaPrefix) {
        this.configurator = configurator;
        this.connectionProvider = connectionProvider;
        this.schemaPrefix = schemaPrefix;
    }

    public String getDetails() {
        String details = this.configurator.getDatabaseProductName() + " " + this.configurator.getDatabaseProductVersion();
        return details.replaceAll("\n", " ");
    }

    public List<String> getSupportedSchemas() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(SCHEMA_DB2);
        result.add(SCHEMA_DB2_OS3980);
        result.add(SCHEMA_DERBY);
        result.add(SCHEMA_HSQLDB);
        result.add(SCHEMA_H2);
        result.add(SCHEMA_MYSQL);
        result.add(SCHEMA_ORACLE);
        result.add(SCHEMA_POINTBASE);
        result.add(SCHEMA_POSTGRESQL);
        result.add(SCHEMA_SQLSERVER);
        result.add(SCHEMA_SYBASE);
        return result;
    }

    public String getMatchingSchemaName() {
        String productName;
        String url = this.configurator.getDatabaseURL();
        if (url != null) {
            if ((url = url.toLowerCase()).startsWith("jdbc:jtds:sybase")) {
                return SCHEMA_SYBASE;
            }
            if (url.startsWith("jdbc:jtds:sqlserver")) {
                return SCHEMA_SQLSERVER;
            }
        }
        if ((productName = this.configurator.getDatabaseProductName()) != null) {
            if ((productName = productName.toLowerCase()).contains(SCHEMA_DB2)) {
                return SCHEMA_DB2;
            }
            if (productName.contains(SCHEMA_DERBY)) {
                return SCHEMA_DERBY;
            }
            if (productName.contains("hsql")) {
                return SCHEMA_HSQLDB;
            }
            if (productName.contains(SCHEMA_H2)) {
                return SCHEMA_H2;
            }
            if (productName.contains(SCHEMA_MYSQL)) {
                return SCHEMA_MYSQL;
            }
            if (productName.contains(SCHEMA_ORACLE)) {
                return SCHEMA_ORACLE;
            }
            if (productName.contains(SCHEMA_POINTBASE)) {
                return SCHEMA_POINTBASE;
            }
            if (productName.contains(SCHEMA_POSTGRESQL)) {
                return SCHEMA_POSTGRESQL;
            }
            if (productName.contains(SCHEMA_SYBASE) || productName.contains("adaptive server enterprise")) {
                return SCHEMA_SYBASE;
            }
            if (productName.contains("sql server")) {
                return SCHEMA_SQLSERVER;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchema(String schemaName) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(this.schemaPrefix + schemaName + ".sql");
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IlrFileUtil.copy(is, baos);
        }
        finally {
            is.close();
        }
        return baos.toString("UTF-8");
    }

    public abstract void executeSQL(String var1) throws DAOException;

    public List<String> getSQLStatements(String sqlStatements) {
        ArrayList<String> result = new ArrayList<String>();
        if (sqlStatements == null || sqlStatements.length() == 0) {
            return result;
        }
        sqlStatements = Pattern.compile("(/\\*.*?\\*/)|(#[^\n]*)|(//[^\n]*)|(--[^\n]*)", 32).matcher(sqlStatements).replaceAll("");
        StringTokenizer tokenizer = new StringTokenizer(sqlStatements, ";");
        while (tokenizer.hasMoreTokens()) {
            String sqlStatement = tokenizer.nextToken().trim();
            if (sqlStatement.length() <= 0) continue;
            result.add(sqlStatement.trim());
        }
        return result;
    }

    public String autoCreateSchema() throws IOException {
        String schemaName = this.getMatchingSchemaName();
        if (schemaName == null) {
            throw new IllegalStateException(IlrDAOLocalization.HELPER.getLocalizedMessage(IlrDAOLocalization.ERROR_NO_MATCHING_SCHEMA_FOUND));
        }
        String sql = this.getSchema(schemaName);
        if (sql == null || sql.length() == 0) {
            throw new IllegalStateException(IlrDAOLocalization.HELPER.getLocalizedMessage(IlrDAOLocalization.ERROR_NO_SCHEMA_FOUND));
        }
        ArrayList<String> statements = new ArrayList<String>();
        if (this.configurator.getUserName() != null) {
            statements.add("CREATE SCHEMA " + this.configurator.getUserName());
        }
        statements.addAll(this.getSQLStatements(sql));
        StringBuffer buffer = new StringBuffer();
        buffer.append("# DB infos: ").append(this.getDetails()).append('\n');
        buffer.append("# schema : ").append(schemaName).append('\n');
        buffer.append("# Begin drop and create tables\n");
        for (String sqlStatement : statements) {
            buffer.append("Execute: ").append(sqlStatement).append('\n');
            try {
                this.executeSQL(sqlStatement);
                buffer.append("\tOK").append('\n');
            }
            catch (DAOException e) {
                buffer.append("\tKO: ").append(e.getCause().getMessage()).append('\n');
            }
        }
        buffer.append("# End drop and create tables\n");
        DiagnosticResult diagResult = this.executeDiagnostic();
        if (diagResult.getError() != null) {
            throw new RuntimeException(buffer.toString(), diagResult.getError());
        }
        buffer.append("# Diagnostic:").append('\n');
        buffer.append(diagResult.getInfos());
        return buffer.toString();
    }

    public abstract DiagnosticResult executeDiagnostic();
}

