/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.jdbc;

import com.ibm.rules.res.message.internal.LocalizedException;
import com.ibm.rules.res.model.MutableXOMLibraryInformation;
import com.ibm.rules.res.model.XOMLibraryId;
import com.ibm.rules.res.model.XOMRepositoryFactory;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.model.internal.XOMLibraryIdImpl;
import com.ibm.rules.res.model.internal.XOMResourceIdImpl;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.DiagnosticResult;
import com.ibm.rules.res.persistence.Transaction;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import com.ibm.rules.res.persistence.internal.DiagnosticResultImpl;
import com.ibm.rules.res.persistence.internal.SHA1ChecksumProvider;
import com.ibm.rules.res.persistence.internal.XOMLoadingCaller;
import com.ibm.rules.res.persistence.internal.jdbc.DAOConfigurator;
import com.ibm.rules.res.persistence.internal.jdbc.GenericDAO;
import com.ibm.rules.res.persistence.internal.jdbc.JDBCTransaction;
import com.ibm.rules.res.persistence.internal.jdbc.helper.Diagnostic;
import com.ibm.rules.res.persistence.internal.jdbc.helper.LibrariesTable;
import com.ibm.rules.res.persistence.internal.jdbc.helper.LibraryValuesTable;
import com.ibm.rules.res.persistence.internal.jdbc.helper.ResourcesTable;
import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.persistence.IlrResourceNotFoundDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipInputStream;

public class GenericXOMRepositoryDAO
extends GenericDAO
implements XOMRepositoryDAO,
XOMLoadingCaller {
    public GenericXOMRepositoryDAO(DAOConfigurator configurator, IlrJDBCConnectionProvider connectionProvider) {
        super(configurator, connectionProvider, "xomrepository_");
    }

    @Override
    public XOMResourceId addResource(String name, IlrVersion version, InputStream data) throws DAOException, IlrResourceNotFoundDAOException {
        byte[] content = null;
        byte[] sha1 = null;
        XOMResourceId result = null;
        try {
            content = StreamUtil.toByteArray(data);
            sha1 = name.toLowerCase().endsWith(".zip") ? SHA1ChecksumProvider.computeSHA1(new ZipInputStream(StreamUtil.toStream(content))) : SHA1ChecksumProvider.computeSHA1(StreamUtil.toStream(content));
            result = this.isAvailable(name, sha1);
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_ADD_XOM, new String[]{XOMInternalNameUtil.getInternalName(result)}, e);
        }
        Transaction transaction = this.beginTransaction();
        try {
            result = this.addResource(name, version, StreamUtil.toStream(content), sha1, transaction);
            transaction.commit();
            XOMResourceId xOMResourceId = result;
            return xOMResourceId;
        }
        catch (DAOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public XOMResourceId addResource(String name, IlrVersion version, InputStream data, Transaction transaction) throws DAOException, IlrResourceNotFoundDAOException {
        byte[] content = null;
        byte[] sha1 = null;
        XOMResourceId result = null;
        try {
            content = StreamUtil.toByteArray(data);
            sha1 = name.toLowerCase().endsWith(".zip") ? SHA1ChecksumProvider.computeSHA1(new ZipInputStream(StreamUtil.toStream(content))) : SHA1ChecksumProvider.computeSHA1(StreamUtil.toStream(content));
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_ADD_XOM, new String[]{XOMInternalNameUtil.getInternalName(result)}, e);
        }
        return this.addResource(name, version, data, sha1, transaction);
    }

    private XOMResourceId addResource(String name, IlrVersion version, InputStream data, byte[] sha1, Transaction transaction) throws DAOException, IlrResourceNotFoundDAOException {
        if (data == null) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_XOM_DATA_NULL, new String[]{String.valueOf(name)});
        }
        XOMResourceIdImpl result = new XOMResourceIdImpl(name, version);
        JDBCTransaction tr = (JDBCTransaction)transaction;
        try {
            this.removeResource(result, transaction);
            ResourcesTable.insert(this.configurator, tr.getConnection(), result.getName(), version, sha1, StreamUtil.toByteArray(data));
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_ADD_XOM, new String[]{XOMInternalNameUtil.getInternalName(result)}, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiagnosticResult executeDiagnostic() {
        Connection connection = null;
        try {
            connection = this.connectionProvider.getConnection();
            DatabaseMetaData metadata = connection.getMetaData();
            Properties props = Diagnostic.fillMetaData(this.getClass(), metadata);
            boolean c1 = Diagnostic.checkLibrariesTable(this.configurator, metadata, props);
            boolean c2 = Diagnostic.checkResourcesTable(this.configurator, metadata, props);
            boolean c3 = Diagnostic.checkLibraryValuesTable(this.configurator, metadata, props);
            DiagnosticResultImpl diagnosticResultImpl = new DiagnosticResultImpl(props, c1 && c2 && c3);
            return diagnosticResultImpl;
        }
        catch (Exception e) {
            DiagnosticResultImpl diagnosticResultImpl = new DiagnosticResultImpl(e);
            return diagnosticResultImpl;
        }
        finally {
            IlrDatabaseUtility.closeConnection(connection);
        }
    }

    @Override
    public byte[] getContent(XOMResourceId resourceId) throws DAOException, IlrResourceNotFoundDAOException {
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            byte[] result = ResourcesTable.getData(this.configurator, transaction.getConnection(), resourceId.getName(), resourceId.getVersion());
            transaction.commit();
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e) {
            transaction.rollback();
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.LOAD_REPOSITORY_ERROR, e);
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public XOMResourceId isAvailable(String name, byte[] sha1) throws DAOException, IlrResourceNotFoundDAOException {
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            XOMResourceId resourceID = ResourcesTable.getId(this.configurator, transaction.getConnection(), name, sha1);
            transaction.commit();
            XOMResourceId xOMResourceId = resourceID;
            return xOMResourceId;
        }
        catch (Exception e) {
            transaction.rollback();
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_GET_XOM_ID, e);
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public XOMResourceId isAvailable(String name, IlrVersion version) throws DAOException, IlrResourceNotFoundDAOException {
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            XOMResourceId resourceID = null;
            if (version == null) {
                Set<XOMResourceId> resources = ResourcesTable.getId(this.configurator, transaction.getConnection(), name);
                for (XOMResourceId tmpResourceId : resources) {
                    if (resourceID == null) {
                        resourceID = tmpResourceId;
                        continue;
                    }
                    if (resourceID.getVersion().compareTo(tmpResourceId.getVersion()) >= 0) continue;
                    resourceID = tmpResourceId;
                }
            } else {
                resourceID = ResourcesTable.getId(this.configurator, transaction.getConnection(), name, version);
            }
            transaction.commit();
            XOMResourceId xOMResourceId = resourceID;
            return xOMResourceId;
        }
        catch (Exception e) {
            transaction.rollback();
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_GET_XOM_ID, e);
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public XOMResourceId getResourceInformation(String name, IlrVersion version) throws DAOException, IlrResourceNotFoundDAOException {
        if (version == null) {
            return new XOMResourceIdImpl(name, version);
        }
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            XOMResourceId resourceID = ResourcesTable.getId(this.configurator, transaction.getConnection(), name, version);
            transaction.commit();
            XOMResourceId xOMResourceId = resourceID;
            return xOMResourceId;
        }
        catch (Exception e) {
            transaction.rollback();
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_GET_XOM_ID, e);
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public XOMLibraryId getLibraryInformation(String name, IlrVersion version) throws DAOException, IlrResourceNotFoundDAOException {
        if (version == null) {
            return new XOMLibraryIdImpl(name, version);
        }
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            Date date = LibrariesTable.getDate(this.configurator, transaction.getConnection(), name, version);
            XOMLibraryIdImpl libraryID = null;
            if (date != null) {
                libraryID = new XOMLibraryIdImpl(name, version);
                libraryID.setDate(date);
            }
            transaction.commit();
            XOMLibraryIdImpl xOMLibraryIdImpl = libraryID;
            return xOMLibraryIdImpl;
        }
        catch (Exception e) {
            transaction.rollback();
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_GET_XOM_ID, e);
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public Set<XOMResourceId> loadResources() throws DAOException {
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            Set<XOMResourceId> result = ResourcesTable.load(this.configurator, transaction.getConnection());
            transaction.commit();
            Set<XOMResourceId> set = result;
            return set;
        }
        catch (Exception e) {
            transaction.rollback();
            throw new DAOException(IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.LOAD_REPOSITORY_ERROR, e));
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public Set<XOMResourceId> loadResources(String name) throws DAOException {
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            Set<XOMResourceId> result = ResourcesTable.load(this.configurator, transaction.getConnection(), name);
            transaction.commit();
            Set<XOMResourceId> set = result;
            return set;
        }
        catch (Exception e) {
            transaction.rollback();
            throw new DAOException(IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.LOAD_REPOSITORY_ERROR, e));
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public Set<XOMLibraryId> loadLibraries() throws DAOException {
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            Set<XOMLibraryId> result = LibrariesTable.load(this.configurator, transaction.getConnection());
            transaction.commit();
            Set<XOMLibraryId> set = result;
            return set;
        }
        catch (Exception e) {
            transaction.rollback();
            throw new DAOException(IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.LOAD_REPOSITORY_ERROR, e));
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public Set<XOMLibraryId> loadLibraries(String name) throws DAOException {
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            Set<XOMLibraryId> result = LibrariesTable.load(this.configurator, transaction.getConnection(), name);
            transaction.commit();
            Set<XOMLibraryId> set = result;
            return set;
        }
        catch (Exception e) {
            transaction.rollback();
            throw new DAOException(IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.LOAD_REPOSITORY_ERROR, e));
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public boolean removeLibrary(XOMLibraryId library) throws DAOException, IlrResourceNotFoundDAOException {
        Transaction transaction = this.beginTransaction();
        boolean result = false;
        try {
            result = this.removeLibrary(library, transaction);
            transaction.commit();
        }
        catch (DAOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
        return result;
    }

    @Override
    public boolean removeLibrary(XOMLibraryId library, Transaction transaction) throws DAOException, IlrResourceNotFoundDAOException {
        JDBCTransaction tr = (JDBCTransaction)transaction;
        try {
            int librarySQLID = LibrariesTable.getId(this.configurator, tr.getConnection(), library.getName(), library.getVersion());
            if (librarySQLID == -1) {
                return false;
            }
            return LibrariesTable.delete(this.configurator, tr.getConnection(), library.getName(), library.getVersion());
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_REMOVE_LIB, new String[]{XOMLibraryIdImpl.getInternalName(library)}, e);
        }
    }

    @Override
    public boolean removeResource(XOMResourceId resourceId) throws DAOException, IlrResourceNotFoundDAOException {
        Transaction transaction = this.beginTransaction();
        boolean result = false;
        try {
            result = this.removeResource(resourceId, transaction);
            transaction.commit();
        }
        catch (DAOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
        return result;
    }

    @Override
    public boolean removeResource(XOMResourceId resourceId, Transaction transaction) throws DAOException, IlrResourceNotFoundDAOException {
        JDBCTransaction tr = (JDBCTransaction)transaction;
        try {
            return ResourcesTable.delete(this.configurator, tr.getConnection(), resourceId.getName(), resourceId.getVersion());
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_ADD_XOM, new String[]{XOMInternalNameUtil.getInternalName(resourceId)}, e);
        }
    }

    @Override
    public Set<XOMLibraryId> isReferenced(String url) throws DAOException {
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        Set<XOMLibraryId> result = null;
        try {
            result = LibrariesTable.isReferenced(this.configurator, transaction.getConnection(), url);
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_XOM_UNKNOWN, e);
        }
        finally {
            transaction.close();
        }
        return result;
    }

    @Override
    public XOMLibraryId addLibrary(String name, IlrVersion version, String[] uris) throws DAOException, IlrResourceNotFoundDAOException {
        Transaction transaction = this.beginTransaction();
        try {
            XOMLibraryId result = this.addLibrary(name, version, uris, transaction);
            transaction.commit();
            XOMLibraryId xOMLibraryId = result;
            return xOMLibraryId;
        }
        catch (DAOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public XOMLibraryId addLibrary(String name, IlrVersion version, String[] uris, Transaction transaction) throws DAOException, IlrResourceNotFoundDAOException {
        assert (name != null);
        assert (version != null);
        if (uris != null && uris.length == 0) {
            uris = null;
        }
        JDBCTransaction tr = (JDBCTransaction)transaction;
        try {
            XOMLibraryIdImpl result = new XOMLibraryIdImpl(name, version);
            this.removeLibrary(result, transaction);
            LibrariesTable.insert(this.configurator, tr.getConnection(), name, version);
            int libraryId = LibrariesTable.getId(this.configurator, tr.getConnection(), name, version);
            if (libraryId == -1) {
                // empty if block
            }
            if (uris != null) {
                for (String uri : uris) {
                    try {
                        XOMInternalNameUtil.validateURL(uri);
                    }
                    catch (LocalizedException e) {
                        throw new DAOException(e);
                    }
                }
                LibraryValuesTable.insertURIs(this.configurator, tr.getConnection(), libraryId, uris);
            }
            return result;
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw e;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_ADD_LIB, new String[]{String.valueOf(name)}, e);
        }
    }

    @Override
    public String[] getContent(XOMLibraryId library) throws DAOException {
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            int libraryId = LibrariesTable.getId(this.configurator, transaction.getConnection(), library.getName(), library.getVersion());
            if (libraryId == -1) {
                transaction.commit();
                String[] stringArray = new String[]{};
                return stringArray;
            }
            Collection<String> urls = LibraryValuesTable.get(this.configurator, transaction.getConnection(), libraryId);
            transaction.commit();
            String[] stringArray = urls.toArray(new String[urls.size()]);
            return stringArray;
        }
        catch (Exception e) {
            transaction.rollback();
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.LOAD_REPOSITORY_ERROR, e);
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public Set<MutableXOMLibraryInformation> loadLibraries(XOMRepositoryFactory factory) throws DAOException {
        JDBCTransaction transaction = (JDBCTransaction)this.beginTransaction();
        try {
            Set<MutableXOMLibraryInformation> result = LibrariesTable.load(factory, this.configurator, transaction.getConnection());
            transaction.commit();
            Set<MutableXOMLibraryInformation> set = result;
            return set;
        }
        catch (Exception e) {
            transaction.rollback();
            throw new DAOException(IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.LOAD_REPOSITORY_ERROR, e));
        }
        finally {
            transaction.close();
        }
    }
}

