/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.jdbc;

import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.Transaction;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.Connection;
import java.sql.SQLException;

public class JDBCTransaction
implements Transaction {
    private final IlrJDBCConnectionProvider connectionProvider;
    private Connection connection;
    private boolean noPreexistingTransaction;

    public JDBCTransaction(IlrJDBCConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void begin() throws DAOException {
        try {
            this.connection = this.connectionProvider.getConnection();
        }
        catch (IlrDAOException e) {
            throw new DAOException(e);
        }
        boolean bl = this.noPreexistingTransaction = !this.connectionProvider.isUnderTransaction();
        if (this.noPreexistingTransaction) {
            try {
                this.connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DAOException(IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.CANNOT_DEACTIVATE_AUTOCOMMIT, e));
            }
        }
    }

    @Override
    public void commit() throws DAOException {
        if (this.noPreexistingTransaction) {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new DAOException(IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.COMMIT_TRANSACTION_ERROR, e));
            }
        }
    }

    @Override
    public void rollback() {
        if (this.noPreexistingTransaction) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        IlrDatabaseUtility.closeConnection(this.connection);
    }
}

