/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.jdbc.helper;

import com.ibm.rules.res.persistence.internal.jdbc.DAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.IlrResourceProviderDescriptorReader;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class Diagnostic {
    private static final String SQLTABLE_XOM_LIBRARIES = "xom_libraries_table";
    private static final String SQLTABLE_XOM_RESOURCES = "xom_resources_table";
    private static final String SQLTABLE_XOM_LIBRARY_VALUES = "xom_library_values_table";
    public static final String DIAG_CLASSNAME = "xomDaoClassName";
    public static final String DIAG_DATABASE_PRODUCT_NAME = "xomDatabaseProductName";
    public static final String DIAG_DATABASE_PRODUCT_VERSION = "xomDatabaseProductVersion";
    public static final String DIAG_DRIVER_NAME = "xomDriverName";
    public static final String DIAG_DRIVER_VERSION = "xomDriverVersion";
    public static final String DIAG_URL = "xomUrl";
    public static final String DIAG_USERNAME = "xomUsername";
    public static final String DIAG_EXISTING_SCHEMAS = "xomExistingSchemas";
    public static final String DIAG_SUPPORTS_TRANSACTIONS = "xomSupportsTransactions";

    public static Properties fillMetaData(Class<?> daoClass, DatabaseMetaData metadata) throws SQLException {
        String username;
        String url;
        String driverVersion;
        String driverName;
        String databaseProductVersion;
        Properties props = new Properties();
        props.setProperty(DIAG_CLASSNAME, daoClass.getName());
        String databaseProductName = metadata.getDatabaseProductName();
        if (databaseProductName != null) {
            props.setProperty(DIAG_DATABASE_PRODUCT_NAME, databaseProductName);
        }
        if ((databaseProductVersion = metadata.getDatabaseProductVersion()) != null) {
            props.setProperty(DIAG_DATABASE_PRODUCT_VERSION, databaseProductVersion);
        }
        if ((driverName = metadata.getDriverName()) != null) {
            props.setProperty(DIAG_DRIVER_NAME, driverName);
        }
        if ((driverVersion = metadata.getDriverVersion()) != null) {
            props.setProperty(DIAG_DRIVER_VERSION, driverVersion);
        }
        if ((url = metadata.getURL()) != null) {
            props.setProperty(DIAG_URL, url);
        }
        if ((username = metadata.getUserName()) != null) {
            props.setProperty(DIAG_USERNAME, username);
        }
        StringBuffer existingSchemas = new StringBuffer();
        ResultSet schemas = metadata.getSchemas();
        int index = 0;
        while (schemas.next()) {
            if (index++ > 0) {
                existingSchemas.append(", ");
            }
            existingSchemas.append(schemas.getString(1));
        }
        if (index > 0) {
            props.setProperty(DIAG_EXISTING_SCHEMAS, existingSchemas.toString());
        }
        props.put(DIAG_SUPPORTS_TRANSACTIONS, (Object)metadata.supportsTransactions());
        return props;
    }

    public static boolean checkLibrariesTable(DAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table ruleAppsTable = configurator.getSQLTable(SQLTABLE_XOM_LIBRARIES);
        boolean isCreated = Diagnostic.checkTable(metadata, "TABLE", ruleAppsTable, metadata.getUserName());
        props.put(SQLTABLE_XOM_LIBRARIES, (Object)isCreated);
        return isCreated;
    }

    public static boolean checkResourcesTable(DAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table rulesetsTable = configurator.getSQLTable(SQLTABLE_XOM_RESOURCES);
        boolean isCreated = Diagnostic.checkTable(metadata, "TABLE", rulesetsTable, metadata.getUserName());
        props.put(SQLTABLE_XOM_RESOURCES, (Object)isCreated);
        return isCreated;
    }

    public static boolean checkLibraryValuesTable(DAOConfigurator configurator, DatabaseMetaData metadata, Properties props) throws SQLException {
        IlrResourceProviderDescriptorReader.Table rulesetsTable = configurator.getSQLTable(SQLTABLE_XOM_LIBRARY_VALUES);
        boolean isCreated = Diagnostic.checkTable(metadata, "TABLE", rulesetsTable, metadata.getUserName());
        props.put(SQLTABLE_XOM_LIBRARY_VALUES, (Object)isCreated);
        return isCreated;
    }

    private static boolean checkTable(DatabaseMetaData metadata, String type, IlrResourceProviderDescriptorReader.Table table, String username) throws SQLException {
        if (Diagnostic.checkTableCreated(metadata, type, username, table)) {
            return true;
        }
        IlrResourceProviderDescriptorReader.Table tableUpperCase = table.toUpperCase();
        String usernameUpperCase = username.toUpperCase();
        IlrResourceProviderDescriptorReader.Table tableLowerCase = table.toLowerCase();
        String usernameLowerCase = username.toLowerCase();
        if (Diagnostic.checkTableCreated(metadata, type, username, tableUpperCase)) {
            return true;
        }
        if (Diagnostic.checkTableCreated(metadata, type, usernameLowerCase, tableUpperCase)) {
            return true;
        }
        if (Diagnostic.checkTableCreated(metadata, type, usernameUpperCase, tableUpperCase)) {
            return true;
        }
        if (Diagnostic.checkTableCreated(metadata, type, username, tableLowerCase)) {
            return true;
        }
        if (Diagnostic.checkTableCreated(metadata, type, usernameLowerCase, tableLowerCase)) {
            return true;
        }
        if (Diagnostic.checkTableCreated(metadata, type, usernameUpperCase, tableLowerCase)) {
            return true;
        }
        String productName = metadata.getDatabaseProductName();
        if (productName == null || !productName.toLowerCase().contains("derby")) {
            if (Diagnostic.checkTableCreated(metadata, type, null, tableUpperCase)) {
                return true;
            }
            if (Diagnostic.checkTableCreated(metadata, type, null, tableLowerCase)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkTableCreated(DatabaseMetaData metadata, String type, String username, IlrResourceProviderDescriptorReader.Table table) throws SQLException {
        ResultSet rs;
        block4: {
            block5: {
                boolean bl;
                String[] tableType = new String[]{type};
                rs = null;
                try {
                    rs = metadata.getTables(null, username, table.getName(), tableType);
                    if (!rs.next()) break block4;
                    String resTableName = rs.getString("TABLE_NAME");
                    if (resTableName == null || !resTableName.equalsIgnoreCase(table.getName())) break block5;
                    boolean columnsChecked = true;
                    for (String columnName : table.getColumns()) {
                        columnsChecked = columnsChecked && Diagnostic.checkColumnCreated(metadata, username, table, columnName);
                    }
                    bl = columnsChecked;
                }
                catch (Throwable throwable) {
                    IlrDatabaseUtility.closeResultSet(rs);
                    throw throwable;
                }
                IlrDatabaseUtility.closeResultSet(rs);
                return bl;
            }
            boolean bl = false;
            IlrDatabaseUtility.closeResultSet(rs);
            return bl;
        }
        IlrDatabaseUtility.closeResultSet(rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkColumnCreated(DatabaseMetaData metadata, String username, IlrResourceProviderDescriptorReader.Table table, String columnName) throws SQLException {
        ResultSet rs;
        block3: {
            block4: {
                boolean bl;
                rs = null;
                try {
                    rs = metadata.getColumns(null, username, table.getName(), columnName);
                    if (!rs.next()) break block3;
                    String resColumnName = rs.getString("COLUMN_NAME");
                    if (resColumnName == null || !resColumnName.equalsIgnoreCase(columnName)) break block4;
                    bl = true;
                }
                catch (Throwable throwable) {
                    IlrDatabaseUtility.closeResultSet(rs);
                    throw throwable;
                }
                IlrDatabaseUtility.closeResultSet(rs);
                return bl;
            }
            boolean bl = false;
            IlrDatabaseUtility.closeResultSet(rs);
            return bl;
        }
        IlrDatabaseUtility.closeResultSet(rs);
        return false;
    }
}

