/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.jdbc.helper;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.model.MutableXOMLibraryInformation;
import com.ibm.rules.res.model.XOMLibraryId;
import com.ibm.rules.res.model.XOMRepositoryFactory;
import com.ibm.rules.res.model.internal.XOMLibraryIdImpl;
import com.ibm.rules.res.persistence.internal.jdbc.DAOConfigurator;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;

public class LibrariesTable {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");
    private static final String SQLST_SELECT_LIBRARIES = "select_libraries";
    private static final String SQLST_SELECT_LIBRARIES_NAME = "select_libraries_name";
    private static final String SQLST_SELECT_LIBRARIES_URL = "select_libraries_url";
    private static final String SQLST_DELETE_LIBRARY = "delete_library";
    private static final String SQLST_INSERT_LIBRARY = "insert_library";
    private static final String SQLST_SELECT_LIBRARY_ID = "select_library_id";
    private static final String SQLST_SELECT_DATE_LIBRARY_ID = "select_date_library_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<XOMLibraryId> load(DAOConfigurator configurator, Connection connection) throws SQLException, IlrFormatException {
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_LIBRARIES);
        HashSet<XOMLibraryId> result = new HashSet<XOMLibraryId>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, new ArrayList<String>());
            while (rs.next()) {
                XOMLibraryIdImpl library = new XOMLibraryIdImpl(rs.getString(1), new IlrVersion(rs.getInt(2), rs.getInt(3)));
                library.setDate(new Date(rs.getLong(4)));
                result.add(library);
            }
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<MutableXOMLibraryInformation> load(XOMRepositoryFactory factory, DAOConfigurator configurator, Connection connection) throws SQLException, IlrFormatException {
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_LIBRARIES);
        HashSet<MutableXOMLibraryInformation> result = new HashSet<MutableXOMLibraryInformation>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, new ArrayList<String>());
            while (rs.next()) {
                MutableXOMLibraryInformation library = factory.createLibrary(rs.getString(1), new IlrVersion(rs.getInt(2), rs.getInt(3)), new Date(rs.getLong(4)));
                result.add(library);
            }
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<XOMLibraryId> load(DAOConfigurator configurator, Connection connection, String name) throws SQLException, IlrFormatException {
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_LIBRARIES_NAME);
        HashSet<XOMLibraryId> result = new HashSet<XOMLibraryId>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, name);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(name);
            }
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues);
            while (rs.next()) {
                XOMLibraryIdImpl library = new XOMLibraryIdImpl(rs.getString(1), new IlrVersion(rs.getInt(2), rs.getInt(3)));
                library.setDate(new Date(rs.getLong(4)));
                result.add(library);
            }
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insert(DAOConfigurator configurator, Connection connection, String name, IlrVersion version) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_LIBRARY);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, name);
            statement.setInt(2, version.getMajor());
            statement.setInt(3, version.getMinor());
            long currentTime = System.currentTimeMillis();
            statement.setLong(4, currentTime);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(name);
                parameterValues.add(String.valueOf(version.getMajor()));
                parameterValues.add(String.valueOf(version.getMinor()));
                parameterValues.add(String.valueOf(currentTime));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getId(DAOConfigurator configurator, Connection connection, String name, IlrVersion version) throws SQLException {
        ResultSet rs;
        PreparedStatement statement;
        block4: {
            int n;
            String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_LIBRARY_ID);
            statement = null;
            rs = null;
            try {
                statement = connection.prepareStatement(sqlStatement);
                statement.setString(1, name);
                statement.setInt(2, version.getMajor());
                statement.setInt(3, version.getMinor());
                ArrayList<String> parameterValues = new ArrayList<String>();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    parameterValues.add(name);
                    parameterValues.add(String.valueOf(version.getMajor()));
                    parameterValues.add(String.valueOf(version.getMinor()));
                }
                if (!(rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues)).next()) break block4;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                IlrDatabaseUtility.closeStatement(statement);
                IlrDatabaseUtility.closeResultSet(rs);
                throw throwable;
            }
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            return n;
        }
        int n = -1;
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDate(DAOConfigurator configurator, Connection connection, String name, IlrVersion version) throws SQLException {
        ResultSet rs;
        PreparedStatement statement;
        block4: {
            Date date;
            String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_DATE_LIBRARY_ID);
            statement = null;
            rs = null;
            try {
                statement = connection.prepareStatement(sqlStatement);
                statement.setString(1, name);
                statement.setInt(2, version.getMajor());
                statement.setInt(3, version.getMinor());
                ArrayList<String> parameterValues = new ArrayList<String>();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    parameterValues.add(name);
                    parameterValues.add(String.valueOf(version.getMajor()));
                    parameterValues.add(String.valueOf(version.getMinor()));
                }
                if (!(rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues)).next()) break block4;
                date = new Date(rs.getLong(1));
            }
            catch (Throwable throwable) {
                IlrDatabaseUtility.closeStatement(statement);
                IlrDatabaseUtility.closeResultSet(rs);
                throw throwable;
            }
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            return date;
        }
        Date date = null;
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(DAOConfigurator configurator, Connection connection, String name, IlrVersion version) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_LIBRARY);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, name);
            statement.setInt(2, version.getMajor());
            statement.setInt(3, version.getMinor());
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(name);
                parameterValues.add(String.valueOf(version.getMajor()));
                parameterValues.add(String.valueOf(version.getMinor()));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<XOMLibraryId> isReferenced(DAOConfigurator configurator, Connection connection, String url) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_LIBRARIES_URL);
        LinkedHashSet<XOMLibraryId> result = new LinkedHashSet<XOMLibraryId>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, url);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(url);
            }
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues);
            while (rs.next()) {
                XOMLibraryIdImpl library = new XOMLibraryIdImpl(rs.getString(1), new IlrVersion(rs.getInt(2), rs.getInt(3)));
                library.setDate(new Date(rs.getLong(4)));
                result.add(library);
            }
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return result;
    }
}

