/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.rest;

import com.ibm.rules.res.model.rest.Resource;
import com.ibm.rules.res.model.rest.Resources;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTActionResult;
import com.ibm.rules.rest.RESTContext;
import com.ibm.rules.rest.RESTPreResponse;
import com.ibm.rules.rest.annotation.ActionResultType;
import com.ibm.rules.rest.annotation.DELETE;
import com.ibm.rules.rest.annotation.Doc;
import com.ibm.rules.rest.annotation.GET;
import com.ibm.rules.rest.annotation.POST;
import com.ibm.rules.rest.annotation.Path;
import com.ibm.rules.rest.annotation.PathParam;
import com.ibm.rules.rest.annotation.Produces;
import com.ibm.rules.rest.annotation.QueryParam;
import com.ibm.rules.rest.annotation.RESTResource;
import com.ibm.rules.rest.annotation.RegExp;

@Path(value="xoms")
@RESTResource(name="xoms", priority=4, version="v1", since="8.0.1.0", title="TITLE_XOMS", summary="SUMMARY_XOMS", introduction="INTRODUCTION_XOMS")
public interface XomsResource {
    @GET
    @Path(value="/")
    @Doc(value="GET_RESOURCES")
    @Produces(value={"application/json", "application/xml"})
    public Resources getResources(RESTContext var1, @QueryParam(value="parts") @Doc(value="RESOURCE_PARTS") String var2);

    @GET
    @Path(value="/{xomname}")
    @Doc(value="GET_RESOURCES_NAME")
    @Produces(value={"application/json", "application/xml"})
    public Resources getResourcesByName(@PathParam(value="xomname") @Doc(value="RESOURCE_NAME") String var1, @QueryParam(value="parts") @Doc(value="RESOURCE_PARTS") String var2, RESTContext var3);

    @GET
    @Path(value="/{xomname}/bytecode")
    @Doc(value="GET_RESOURCE_HIGHEST_BYTECODE")
    @Produces(value={"application/json", "application/xml"})
    public RESTPreResponse getByteCodeOfHighestResource(RESTContext var1, @PathParam(value="xomname") @Doc(value="RESOURCE_NAME") String var2, @QueryParam(value="filename") @Doc(value="FILE_NAME") String var3);

    @GET
    @Path(value="/{xomname}/{xomversion}/bytecode")
    @Doc(value="GET_RESOURCE_BYTECODE")
    @Produces(value={"application/json", "application/xml"})
    public RESTPreResponse getByteCodeOfResource(RESTContext var1, @PathParam(value="xomname") @Doc(value="RESOURCE_NAME") String var2, @PathParam(value="xomversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RESOURCE_VERSION") String var3, @QueryParam(value="filename") @Doc(value="FILE_NAME") String var4);

    @GET
    @Path(value="/{xomname}/{xomversion}")
    @Doc(value="GET_RESOURCE")
    @Produces(value={"application/json", "application/xml"})
    public Resource getResource(RESTContext var1, @PathParam(value="xomname") @Doc(value="RESOURCE_NAME") String var2, @PathParam(value="xomversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RESOURCE_VERSION") String var3, @QueryParam(value="parts") @Doc(value="RESOURCE_PARTS") String var4);

    @GET
    @Path(value="/{xomname}/highest")
    @Doc(value="GET_RESOURCE_HIGHEST")
    @Produces(value={"application/json", "application/xml"})
    public Resource getResourceWithHighestNumber(RESTContext var1, @PathParam(value="xomname") @Doc(value="RESOURCE_NAME") String var2, @QueryParam(value="parts") @Doc(value="RESOURCE_PARTS") String var3);

    @POST
    @Path(value="/{xomname}")
    @Doc(value="ADD_RESOURCE")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=Resource.class)
    public RESTActionResult deployResource(RESTContext var1, @PathParam(value="xomname") @Doc(value="RESOURCE_NAME") String var2, @Doc(value="RESOURCE_BYTECODE") byte[] var3) throws HTTPError;

    @DELETE
    @Path(value="/{xomname}/{xomversion}")
    @Doc(value="DELETE_RESOURCE")
    @Produces(value={"application/json", "application/xml"})
    public RESTActionResult deleteResource(RESTContext var1, @PathParam(value="xomname") @Doc(value="RESOURCE_NAME") String var2, @PathParam(value="xomversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RESOURCE_VERSION") String var3);
}

