/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.urlhandler;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.model.internal.XOMResourceIdImpl;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.res.persistence.IlrResourceNotFoundDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class URLConnectionBase
extends URLConnection {
    private final transient RESLogger logger = RESLogger.getRESLogger("com.ibm.rules.res.persistence", "ilog.rules.res.persistence.impl.messages");
    private final String BUNDLE_NAME = "ilog.rules.res.persistence.impl.messages";
    private final ResourceBundle BUNDLE = ResourceBundle.getBundle("ilog.rules.res.persistence.impl.messages");
    private final boolean debug = this.logger.isLoggable(Level.FINEST);
    private static Map<XOMResourceId, WeakReference<Map<String, ClassByteCode>>> resourceId2name2bytecode = new WeakHashMap<XOMResourceId, WeakReference<Map<String, ClassByteCode>>>();

    public URLConnectionBase(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
    }

    protected abstract byte[] getResourceContent(XOMResourceId var1) throws IlrResourceNotFoundDAOException, DAOException;

    protected abstract boolean isResourceContentAvailable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassByteCode getByteCode(XOMResourceId resourceId, String jarName, String className) throws IlrResourceNotFoundDAOException, DAOException {
        Map<XOMResourceId, WeakReference<Map<String, ClassByteCode>>> map = resourceId2name2bytecode;
        synchronized (map) {
            WeakReference<Map<String, ClassByteCode>> cacheRef;
            if (this.debug) {
                this.logger.log(Level.INFO, IlrDAOLocalization.XOM_CLASS_SEARCH_IN_PERSISTENCE, new Object[]{className, jarName}, null);
            }
            if ((cacheRef = resourceId2name2bytecode.get(resourceId)) != null) {
                Map cache;
                if (this.debug) {
                    this.logger.log(Level.INFO, IlrDAOLocalization.XOM_URI_ALREADY_LOADED_IN_MEMORY, new Object[]{resourceId}, null);
                }
                if ((cache = (Map)cacheRef.get()) != null) {
                    return (ClassByteCode)cache.get(className);
                }
                if (this.debug) {
                    this.logger.log(Level.INFO, IlrDAOLocalization.XOM_URI_GARBAGE_COLLECTED, null, null);
                }
            }
            byte[] content = this.getResourceContent(resourceId);
            Map<String, ClassByteCode> cache = this.registerJar(jarName, content);
            resourceId2name2bytecode.put(resourceId, new WeakReference<Map<String, ClassByteCode>>(cache));
            return cache.get(className);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isResourceContentAvailable()) {
            try {
                ClassByteCode byteCode;
                XOMResourceId resourceId;
                String internalName = this.getURL().getHost();
                String className = URLDecoder.decode(this.getURL().getFile().substring(1), "UTF-8");
                if (Character.isDigit(className.charAt(0))) {
                    int slashIndex = className.indexOf(47);
                    internalName = internalName + '/' + className.substring(0, slashIndex);
                    className = className.substring(slashIndex + 1);
                }
                if ((resourceId = XOMInternalNameUtil.getXOMResourceId(internalName)) == null) {
                    resourceId = new XOMResourceIdImpl(internalName, null);
                }
                if ((byteCode = this.getByteCode(resourceId, internalName, className)) == null) {
                    if (this.debug) {
                        this.logger.log(Level.INFO, IlrDAOLocalization.RESOURCE_NOT_FOUND_IN_XOM_URI, new Object[]{className, internalName}, null);
                    }
                    throw new ClassNotFoundException(className);
                }
                return StreamUtil.toStream(byteCode.content);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        throw new IOException(this.BUNDLE.getString(IlrDAOLocalization.XOM_REPOSITORY_NOT_SET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ClassByteCode> registerJar(String jarName, byte[] content) {
        HashMap<String, ClassByteCode> name2bytecode = new HashMap<String, ClassByteCode>();
        ZipInputStream jis = null;
        try {
            jis = new JarInputStream(new ByteArrayInputStream(content));
            ZipEntry entry = null;
            while ((entry = ((JarInputStream)jis).getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                    IlrFileUtil.copy((InputStream)jis, baos);
                    jis.closeEntry();
                    name2bytecode.put(entry.getName(), new ClassByteCode(baos.toByteArray()));
                    if (this.debug) {
                        this.logger.log(Level.INFO, IlrDAOLocalization.LOAD_RESOURCE_JAR_IN_MEMORY, new Object[]{entry.getName(), jarName}, null);
                    }
                }
                jis.closeEntry();
            }
        }
        catch (IOException e) {
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException e) {}
            }
        }
        return name2bytecode;
    }

    private static class ClassByteCode {
        byte[] content;

        public ClassByteCode(byte[] content) {
            this.content = content;
        }
    }
}

