/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.util.internal;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTTPTransparentNegociation {
    private final Set<TNPart> parts = new TreeSet<TNPart>();
    protected static final Pattern PATTERN_CONTENT_PART = Pattern.compile("(?: *)?([^/;:]+)(?:/([^;:]*))?(?: *)?(?:[;|:](?: *)?q(?: *)?=(?: *)?(.*\\..*))?");

    public HTTPTransparentNegociation(String input) {
        this.parseNegociationString(input);
    }

    protected void parseNegociationString(String input) {
        if (input == null) {
            return;
        }
        String[] chunks = input.split(",");
        for (int i = 0; i < chunks.length; ++i) {
            String chunk = chunks[i];
            Matcher m = PATTERN_CONTENT_PART.matcher(chunk);
            if (!m.matches()) {
                this.parts.add(new TNPart(i, chunk, null, -1.0));
                continue;
            }
            String root = m.group(1);
            String complement = m.group(2);
            String qualityString = m.group(3);
            double quality = 1.0;
            if (qualityString != null) {
                try {
                    quality = Double.parseDouble(qualityString);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.parts.add(new TNPart(i, root, complement, quality));
        }
    }

    public Set<TNPart> getParts() {
        return this.parts;
    }

    public static final class TNPart
    implements Comparable<TNPart> {
        private final int index;
        private final String root;
        private final String complement;
        private double quality = 1.0;

        public TNPart(int index, String root, String complement, double quality) {
            this.index = index;
            this.root = root;
            this.complement = complement;
            this.quality = quality;
        }

        @Override
        public int compareTo(TNPart o) {
            int result = Double.compare(o.quality, this.quality);
            if (result == 0) {
                return this.index - o.index;
            }
            return result;
        }

        public int getIndex() {
            return this.index;
        }

        public String getRoot() {
            return this.root;
        }

        public String getComplement() {
            return this.complement;
        }

        public double getQuality() {
            return this.quality;
        }
    }
}

