/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.util.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesConverter {
    public static String toString(Map<String, ?> map) {
        if (map == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue().toString();
            value = value.replaceAll("\\\\", "\\\\\\\\");
            value = value.replaceAll(",", "\\\\,");
            if (!first) {
                result.append(",");
            } else {
                first = false;
            }
            result.append(key);
            result.append("=");
            result.append(value);
        }
        return result.toString();
    }

    public static Map<String, String> toMap(String pinput) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (pinput == null) {
            return properties;
        }
        int i = 0;
        String input = pinput.trim();
        int length = input.length();
        while (i < length) {
            String key = "";
            String value = "";
            int startKey = i;
            int nbEscape = 0;
            while (i < length && (input.charAt(i) != '=' && input.charAt(i) != ',' || (nbEscape & 1) > 0)) {
                nbEscape = input.charAt(i) == '\\' ? ++nbEscape : 0;
                ++i;
            }
            int endKey = i;
            key = input.substring(startKey, endKey);
            key = key.trim();
            if (i < length && input.charAt(i) == '=' && (nbEscape & 1) == 0) {
                int startValue = ++i;
                nbEscape = 0;
                while (i < length && (input.charAt(i) != ',' || (nbEscape & 1) > 0)) {
                    nbEscape = input.charAt(i) == '\\' ? ++nbEscape : 0;
                    ++i;
                }
                int endValue = i;
                value = input.substring(startValue, endValue);
                value = value.trim();
            }
            ++i;
            StringBuffer keyRes = new StringBuffer(key);
            for (int j = 0; j < keyRes.length(); ++j) {
                if (keyRes.charAt(j) != '\\') continue;
                keyRes.deleteCharAt(j);
            }
            StringBuffer valueRes = new StringBuffer(value);
            for (int j = 0; j < valueRes.length(); ++j) {
                if (valueRes.charAt(j) != '\\') continue;
                valueRes.deleteCharAt(j);
            }
            if (keyRes.toString().equals("")) continue;
            properties.put(keyRes.toString(), valueRes.toString());
        }
        return properties;
    }

    public static Properties toProperties(String input) {
        Properties properties = new Properties();
        Map<String, String> map = PropertiesConverter.toMap(input);
        for (String key : map.keySet()) {
            String value = map.get(key);
            properties.put(key, value);
        }
        return properties;
    }

    public static Properties toProperties(Map<String, String> props) {
        Properties result = new Properties();
        for (Map.Entry<String, String> e : props.entrySet()) {
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }
}

