/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.util.internal;

import com.ibm.rules.res.util.internal.InternalByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtil {
    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[1024];
        int i = 0;
        while ((i = input.read(buffer)) != -1) {
            output.write(buffer, 0, i);
        }
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        if (stream instanceof InternalByteArrayInputStream) {
            return ((InternalByteArrayInputStream)stream).getByteArray();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtil.copy(stream, baos);
        baos.close();
        return baos.toByteArray();
    }

    public static InputStream toStream(byte[] byteArray) {
        if (byteArray == null) {
            byteArray = new byte[]{};
        }
        return new InternalByteArrayInputStream(byteArray);
    }

    public static String toString(InputStream stream) {
        int count = 0;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] byteArray = new byte[1024];
        try {
            while ((count = stream.read(byteArray, 0, byteArray.length)) > 0) {
                outputStream.write(byteArray, 0, count);
            }
            return new String(outputStream.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

