/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xml.internal;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

public class HTDSStartElement
implements StartElement {
    private Map<QName, Attribute> name2attributes = new HashMap<QName, Attribute>();
    private List<Namespace> namespaces = new ArrayList<Namespace>();
    private StartElement wrappedStartElement;

    public HTDSStartElement(StartElement startElement) {
        this.wrappedStartElement = startElement;
        Iterator<Attribute> it = startElement.getNamespaces();
        while (it.hasNext()) {
            this.namespaces.add(it.next());
        }
        it = startElement.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            this.name2attributes.put(attr.getName(), attr);
        }
    }

    @Override
    public Attribute getAttributeByName(QName qname) {
        if (qname == null) {
            return null;
        }
        return this.name2attributes.get(qname);
    }

    public Iterator getAttributes() {
        Collection<Attribute> coll = this.name2attributes.values();
        return coll.iterator();
    }

    @Override
    public QName getName() {
        return this.wrappedStartElement.getName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.wrappedStartElement.getNamespaceContext();
    }

    public String getNamespace() {
        return this.getName().getNamespaceURI();
    }

    public Namespace addNamespaceIfNotExists(Namespace ns) {
        for (Namespace tmp : this.namespaces) {
            if (!tmp.getPrefix().equals(ns.getPrefix())) continue;
            return tmp;
        }
        this.namespaces.add(ns);
        return null;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.getNamespace() != null && this.getName().getPrefix().equals(prefix)) {
            return this.getNamespace();
        }
        if (this.getNamespaceContext() != null) {
            return this.getNamespaceContext().getNamespaceURI(prefix);
        }
        return null;
    }

    public Iterator getNamespaces() {
        return this.namespaces.iterator();
    }

    @Override
    public Characters asCharacters() {
        HTDSStartElement result = this;
        return (Characters)((Object)result);
    }

    @Override
    public EndElement asEndElement() {
        HTDSStartElement result = this;
        return (EndElement)((Object)result);
    }

    @Override
    public StartElement asStartElement() {
        return this;
    }

    @Override
    public int getEventType() {
        return this.wrappedStartElement.getEventType();
    }

    @Override
    public Location getLocation() {
        return this.wrappedStartElement.getLocation();
    }

    @Override
    public QName getSchemaType() {
        return this.wrappedStartElement.getSchemaType();
    }

    @Override
    public boolean isAttribute() {
        return this.wrappedStartElement.isAttribute();
    }

    @Override
    public boolean isCharacters() {
        return this.wrappedStartElement.isCharacters();
    }

    @Override
    public boolean isEndDocument() {
        return this.wrappedStartElement.isEndDocument();
    }

    @Override
    public boolean isEndElement() {
        return this.wrappedStartElement.isEndElement();
    }

    @Override
    public boolean isEntityReference() {
        return this.wrappedStartElement.isEntityReference();
    }

    @Override
    public boolean isNamespace() {
        return this.wrappedStartElement.isNamespace();
    }

    @Override
    public boolean isProcessingInstruction() {
        return this.wrappedStartElement.isProcessingInstruction();
    }

    @Override
    public boolean isStartDocument() {
        return this.wrappedStartElement.isStartDocument();
    }

    @Override
    public boolean isStartElement() {
        return this.wrappedStartElement.isStartElement();
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        this.wrappedStartElement.writeAsEncodedUnicode(writer);
    }
}

