/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xml.internal;

import com.ibm.rules.res.logging.internal.AbstractLogger;
import com.ibm.rules.res.xml.internal.StAXFactory;
import com.ibm.rules.res.xml.internal.XSDUtil;
import com.ibm.rules.res.xml.internal.XSDWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XSD {
    private Map<String, XSDWrapper> imports;
    private final List<Namespace> namespaces = new ArrayList<Namespace>();
    private List<String> includes;
    private String defaultNamespace;
    private boolean flattenedInclusion;
    private String targetNamespace;
    private byte[] originalXSD;
    private Queue<XMLEvent> events;
    private Element element;
    private AbstractLogger logger;
    private String xsdNamespace;

    public XSD(AbstractLogger logger) {
        this.logger = logger;
    }

    public XSD(Element element) {
        this.element = element;
    }

    public XSD(byte[] originalXSD) {
        this.originalXSD = originalXSD;
    }

    public Map<String, XSDWrapper> getImports() {
        return this.imports;
    }

    Map<String, XSDWrapper> getImportsNotNull() {
        if (this.imports == null) {
            this.imports = new HashMap<String, XSDWrapper>();
        }
        return this.imports;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    List<String> getIncludesNotNull() {
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
        }
        return this.includes;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getXSDNamespace() {
        return this.xsdNamespace;
    }

    public void setXSDNamespace(String xsdNamespace) {
        this.xsdNamespace = xsdNamespace;
    }

    public byte[] getOriginalXSD() {
        return this.originalXSD;
    }

    public void setOriginalXSD(byte[] originalXSD) {
        this.originalXSD = originalXSD;
    }

    public Queue<XMLEvent> getEvents() {
        if (this.events == null && this.element != null) {
            try {
                DOMSource source = new DOMSource(this.element);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(baos);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.transform(source, result);
                this.events = new XSDUtil(null).analyse(new ByteArrayInputStream(baos.toByteArray()), true, null).getEvents();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.events;
    }

    Queue<XMLEvent> getEventsNotNull() {
        if (this.events == null) {
            this.events = new LinkedList<XMLEvent>();
        }
        return this.events;
    }

    public void setEvents(Queue<XMLEvent> events) {
        this.events = events;
    }

    public boolean isFlattenedInclusion() {
        return this.flattenedInclusion;
    }

    public void setFlattenedInclusion(boolean flattenedInclusion) {
        this.flattenedInclusion = flattenedInclusion;
    }

    public Element getElement() {
        if (this.element == null) {
            if (this.events != null) {
                try {
                    XMLOutputFactory xof = StAXFactory.newXMLOutputFactory(this.logger);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XMLEventWriter writer = xof.createXMLEventWriter(baos, "UTF-8");
                    boolean startElement = false;
                    int depth = 0;
                    for (XMLEvent event : this.events) {
                        if (!startElement) {
                            if (!event.isStartElement()) continue;
                            startElement = true;
                        }
                        if (event.isStartElement()) {
                            ++depth;
                        }
                        if (depth > 0) {
                            writer.add(event);
                        }
                        if (!event.isEndElement()) continue;
                        --depth;
                    }
                    writer.close();
                    baos.close();
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(new InputSource(new ByteArrayInputStream(baos.toByteArray())));
                    this.element = doc.getDocumentElement();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.originalXSD != null) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(new InputSource(new ByteArrayInputStream(this.originalXSD)));
                    this.element = doc.getDocumentElement();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }
}

