/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.cacache.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.cacache.internal.CACache;
import com.ibm.rules.res.xu.cacache.internal.CACacheException;
import ilog.rules.res.util.io.IlrFilePrivilegedAction;
import ilog.rules.res.util.io.IlrFileStreamPrivilegedAction;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleCACacheImpl
implements CACache {
    public static final String KEY_DIRECTORY = "path";
    public static final String KEY_MAXSIZE = "maxSize";
    protected static final String FILENAME_INFO = "cache.props";
    protected static final int DEFAULT_MAXSIZE = 10;
    protected File root;
    protected File infoFile;
    protected int maxSize = 10;
    protected final Map<String, Long> lastUsageTimes = new HashMap<String, Long>();
    protected Logger log;

    @Override
    public final void initialize(Map<String, String> props) throws CACacheException {
        if (props == null) {
            throw new CACacheException();
        }
        this.finest(".initialize()");
        String dir = props.get(KEY_DIRECTORY);
        if (dir == null) {
            throw new CACacheException();
        }
        this.root = new File(dir);
        this.finest(".initialize(): dir=" + this.root);
        IlrFilePrivilegedAction.mkdirs(this.root);
        this.infoFile = new File(this.root, FILENAME_INFO);
        this.log.finest(".initialize(): info=" + this.infoFile);
        String str = props.get(KEY_MAXSIZE);
        if (str != null && !str.isEmpty()) {
            this.maxSize = Integer.parseInt(str);
        }
        this.loadInfo();
    }

    @Override
    public final synchronized void setLogger(Logger log) {
        this.log = log;
    }

    protected final void removeOlder() {
        long lastUsageTime = 0L;
        String id = null;
        for (Map.Entry<String, Long> e : this.lastUsageTimes.entrySet()) {
            long t = e.getValue();
            if (lastUsageTime != 0L && t >= lastUsageTime) continue;
            id = e.getKey();
            lastUsageTime = t;
        }
        if (id != null) {
            File f = new File(this.root, id);
            IlrFilePrivilegedAction.delete(f);
            this.lastUsageTimes.remove(id);
        }
    }

    @Override
    public final synchronized void put(String id, InputStream data) throws CACacheException {
        File f;
        File d;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(".put(): id=" + id);
            this.log.finest(".put(): size=" + this.size());
        }
        if (this.size() >= this.maxSize) {
            this.removeOlder();
        }
        if ((d = (f = new File(this.root, id)).getParentFile()) != null) {
            d.mkdirs();
        }
        OutputStream out = null;
        BufferedInputStream bin = null;
        try {
            int n;
            out = IlrFileStreamPrivilegedAction.newOutputStream(f);
            bin = new BufferedInputStream(data);
            byte[] buf = new byte[64000];
            while ((n = bin.read(buf)) != -1) {
                out.write(buf, 0, n);
            }
            this.lastUsageTimes.put(id, System.currentTimeMillis());
            this.saveInfo();
        }
        catch (IOException e) {
            throw new CACacheException(XUMessageCode.ERROR_CA_CACHE_ERROR, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public final synchronized InputStream get(String id) throws CACacheException {
        File f = new File(this.root, id);
        if (!IlrFilePrivilegedAction.exists(f).booleanValue()) {
            return null;
        }
        try {
            InputStream in = IlrFileStreamPrivilegedAction.newInputStream(f);
            this.lastUsageTimes.put(id, System.currentTimeMillis());
            this.saveInfo();
            return in;
        }
        catch (FileNotFoundException e) {
            throw new CACacheException(XUMessageCode.ERROR_CA_CACHE_ERROR, e);
        }
    }

    protected final int size() {
        File[] files = this.root.listFiles();
        if (files == null) {
            return 0;
        }
        int n = 0;
        for (File f : files) {
            if (f.getName().equals(FILENAME_INFO)) continue;
            n += IlrFileUtil.countFiles(f);
        }
        return n;
    }

    protected final void loadInfo() throws CACacheException {
        if (!this.infoFile.exists()) {
            return;
        }
        Properties props = new Properties();
        FileReader in = null;
        try {
            in = new FileReader(this.infoFile);
            props.load(in);
            for (Object k : props.keySet()) {
                this.lastUsageTimes.put((String)k, Long.parseLong(props.getProperty((String)k)));
            }
        }
        catch (IOException e) {
            throw new CACacheException(XUMessageCode.ERROR_CA_CACHE_ERROR, e);
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected final void saveInfo() throws CACacheException {
        Properties props = new Properties();
        for (Map.Entry<String, Long> e : this.lastUsageTimes.entrySet()) {
            props.put(e.getKey(), Long.toString(e.getValue()));
        }
        FileWriter out = null;
        try {
            out = new FileWriter(this.infoFile);
            props.store(out, null);
        }
        catch (IOException e) {
            throw new CACacheException(XUMessageCode.ERROR_CA_CACHE_ERROR, e);
        }
        finally {
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected final void finest(String msg) {
        this.log.finest(this.getClass().getName() + msg);
    }
}

