/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal;

import com.ibm.rules.res.util.internal.PropertiesConverter;
import com.ibm.rules.res.xu.client.internal.PoolConfigImpl;
import com.ibm.rules.res.xu.client.internal.XUConfigImpl;
import com.ibm.rules.res.xu.client.internal.jca.DescriptorException;
import com.ibm.rules.res.xu.config.internal.ConnectionPoolConfig;
import com.ibm.rules.res.xu.internal.XUException;
import java.util.Map;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectionPoolConfigImpl
extends PoolConfigImpl
implements ConnectionPoolConfig {
    public static final String KEY_MAINTENANCE_PERIOD = "connection.maintenancePeriod";
    public static final String KEY_CONNECTION_IDLE_TIMEOUT = "connection.idleTimeout";

    ConnectionPoolConfigImpl(ManagedConnectionFactory factory) {
        super(factory, "defaultConnectionManagerProperties");
    }

    @Override
    protected String getPropertyKeyMaxSize() {
        return "pool.maxSize";
    }

    @Override
    protected int getDefaultMaxSize() {
        return 10;
    }

    @Override
    protected String getPropertyKeyWaitTimeout() {
        return "pool.waitTimeout";
    }

    @Override
    protected long getDefaultWaitTimeout() {
        return -1L;
    }

    @Override
    public int getMaintenancePeriod() throws XUException {
        Map props = this.toMap();
        String str = (String)props.get(KEY_MAINTENANCE_PERIOD);
        if (str == null) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    @Override
    public void setMaintenancePeriod(int s) throws XUException {
        Map props = this.toMap();
        props.put(KEY_MAINTENANCE_PERIOD, Integer.toString(s));
        this.setProperties(props);
    }

    @Override
    public long getConnectionIdleTimeout() throws XUException {
        Map props = this.toMap();
        String str = (String)props.get(KEY_CONNECTION_IDLE_TIMEOUT);
        if (str == null) {
            return -1L;
        }
        return Integer.parseInt(str);
    }

    @Override
    public void setConnectionIdleTimeout(int s) throws XUException {
        Map props = this.toMap();
        props.put(KEY_CONNECTION_IDLE_TIMEOUT, Integer.toString(s));
        this.setProperties(props);
    }

    @Override
    public void setProperties(Map<String, String> props) throws XUException {
        try {
            XUConfigImpl.setConfigProperty(this.factory, this.poolName, PropertiesConverter.toString(props));
        }
        catch (DescriptorException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

