/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal;

import com.ibm.rules.res.xu.client.internal.XURuleEngineSession;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.xu.cci.IlrConnectionId;
import ilog.rules.res.xu.cci.IlrXUConnection;
import ilog.rules.res.xu.cci.ruleset.IlrRulesetExecutionTrace;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.resource.cci.ConnectionFactory;

public final class DirectXURuleEngineSession
extends XURuleEngineSession {
    private IlrXUConnection xuConnection;

    public DirectXURuleEngineSession(IlrXUConnection connection, ConnectionFactory factory) {
        super(connection, factory);
        this.xuConnection = connection;
    }

    @Override
    public final void close() throws XUException {
        super.close();
        this.xuConnection = null;
    }

    @Override
    public final Map<String, Object> getParameters(byte dir) throws XUException {
        this.checkConnection();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.xuConnection.engineGetParameters(dir, params);
        this.fireWarnings(this.xuConnection);
        return params;
    }

    @Override
    public final Map<String, Object> execute() throws XUException {
        this.checkConnection();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.xuConnection.engineExecute(params);
        this.fireWarnings(this.xuConnection);
        return params;
    }

    @Override
    public final String getOutput() throws XUException {
        this.checkConnection();
        String str = this.xuConnection.engineGetOutput();
        this.fireWarnings(this.xuConnection);
        return str;
    }

    @Override
    public final void setParameters(Map<String, Object> params) throws XUException {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        this.checkConnection();
        this.xuConnection.engineSetParameters(params);
        this.fireWarnings(this.xuConnection);
    }

    @Override
    public final int getFiredRulesCount() throws XUException {
        this.checkConnection();
        int count = this.xuConnection.engineGetFiredRulesCount();
        this.fireWarnings(this.xuConnection);
        return count;
    }

    @Override
    public final void resetRuleflow() throws XUException {
        this.checkConnection();
        this.xuConnection.engineRuleflowReset();
        this.fireWarnings(this.xuConnection);
    }

    @Override
    public final void reset() throws XUException {
        this.checkConnection();
        this.xuConnection.engineReset();
        this.fireWarnings(this.xuConnection);
    }

    @Override
    public IlrConnectionId getConnectionId() throws XUException {
        this.checkConnection();
        IlrConnectionId id = this.xuConnection.getId();
        this.fireWarnings(this.xuConnection);
        return id;
    }

    @Override
    public void enableRulesetExecutionInformation(int filter, Properties props) throws XUException {
        HashMap<String, String> filterProps;
        this.checkConnection();
        if (props == null) {
            filterProps = null;
        } else {
            filterProps = new HashMap<String, String>();
            for (Object k : props.keySet()) {
                filterProps.put(k.toString(), (String)props.get(k));
            }
        }
        this.xuConnection.enableRulesetExecutionInformation(filter, filterProps);
        this.fireWarnings(this.xuConnection);
    }

    @Override
    public final IlrRulesetExecutionTrace getRulesetExecutionTrace() throws XUException {
        this.checkConnection();
        IlrRulesetExecutionTrace trace = this.xuConnection.getRulesetExecutionTrace();
        this.fireWarnings(this.xuConnection);
        return trace;
    }

    @Override
    public final String getCanonicalRulesetPath() throws XUException {
        this.checkConnection();
        String path = this.xuConnection.getXURulesetArchiveInformation().getCanonicalPath().toString();
        this.fireWarnings(this.xuConnection);
        return path;
    }

    @Override
    public Map<String, String> getRulesetArchiveProperties() throws XUException {
        this.checkConnection();
        IlrRulesetArchiveProperties props = this.xuConnection.getXURulesetArchiveInformation().getProperties();
        this.fireWarnings(this.xuConnection);
        return props;
    }

    @Override
    public List<Object> toNodes(List<Object> xom) throws XUException {
        this.checkConnection();
        return this.xuConnection.engineToNodes(xom);
    }

    @Override
    public List<Object> nodesToXOMObjects(List<Object> nodes) throws XUException {
        this.checkConnection();
        return this.xuConnection.engineNodesToXOMObjects(nodes);
    }
}

