/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal;

import com.ibm.rules.res.util.internal.PropertiesConverter;
import com.ibm.rules.res.xu.client.internal.XUConfigImpl;
import com.ibm.rules.res.xu.client.internal.jca.DescriptorException;
import com.ibm.rules.res.xu.config.internal.PoolConfig;
import com.ibm.rules.res.xu.internal.XUException;
import java.util.Map;
import javax.resource.spi.ManagedConnectionFactory;

abstract class PoolConfigImpl
implements PoolConfig {
    protected ManagedConnectionFactory factory;
    protected String poolName;

    public PoolConfigImpl(ManagedConnectionFactory factory, String poolName) {
        this.factory = factory;
        this.poolName = poolName;
    }

    @Override
    public Map<String, String> toMap() throws XUException {
        String strProps = (String)XUConfigImpl.getConfigProperty(this.factory, this.poolName);
        return PropertiesConverter.toMap(strProps);
    }

    protected abstract String getPropertyKeyMaxSize();

    protected abstract int getDefaultMaxSize();

    protected abstract String getPropertyKeyWaitTimeout();

    protected abstract long getDefaultWaitTimeout();

    @Override
    public int getMaxSize() throws XUException {
        Map<String, String> props = this.toMap();
        String str = props.get(this.getPropertyKeyMaxSize());
        if (str == null) {
            return this.getDefaultMaxSize();
        }
        return Integer.parseInt(str);
    }

    @Override
    public void setMaxSize(int size) throws XUException {
        Map<String, String> props = this.toMap();
        props.put(this.getPropertyKeyMaxSize(), Integer.toString(size));
        this.setProperties(props);
    }

    @Override
    public long getWaitTimeout() throws XUException {
        Map<String, String> props = this.toMap();
        String str = props.get(this.getPropertyKeyWaitTimeout());
        if (str == null) {
            return this.getDefaultWaitTimeout();
        }
        return Long.parseLong(str);
    }

    @Override
    public void setWaitTimeout(long t) throws XUException {
        Map<String, String> props = this.toMap();
        props.put(this.getPropertyKeyWaitTimeout(), Long.toString(t));
        this.setProperties(props);
    }

    @Override
    public void putProperty(String k, String v) throws XUException {
        Map<String, String> props = this.toMap();
        props.put(k, v);
        this.setProperties(props);
    }

    @Override
    public void setProperties(Map<String, String> props) throws XUException {
        try {
            XUConfigImpl.setConfigProperty(this.factory, this.poolName, PropertiesConverter.toString(props));
        }
        catch (DescriptorException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

