/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal.jca;

import com.ibm.rules.res.util.internal.PropertiesConverter;
import com.ibm.rules.res.xu.client.internal.PluginConfigImpl;
import com.ibm.rules.res.xu.client.internal.jca.ParseException;
import com.ibm.rules.res.xu.config.internal.PluginConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JCAPluginsPropertyParser {
    public static String toString(List<PluginConfig> cfg) {
        String str = null;
        for (PluginConfig p : cfg) {
            String props = "{" + PropertiesConverter.toString(p.getProperties()) + "}";
            if (str == null) {
                str = props;
                continue;
            }
            str = str + "," + props;
        }
        if (str == null) {
            str = "";
        }
        return str;
    }

    public static List<PluginConfig> parsePluginConfigs(String input) throws ParseException {
        try {
            return JCAPluginsPropertyParser.parse(input);
        }
        catch (ParseException e) {
            throw new ParseException("XU.ERROR.10018", new String[]{input}, (Throwable)e);
        }
    }

    public static List<PluginConfig> parse(String input) throws ParseException {
        ArrayList<PluginConfig> list = new ArrayList<PluginConfig>();
        if (input == null) {
            return list;
        }
        boolean startLine = true;
        int i = 0;
        int length = input.length();
        while (i < length) {
            int end;
            String className;
            while (i < length && Character.isWhitespace(input.charAt(i))) {
                ++i;
            }
            if (i == length) break;
            if (!startLine) {
                if (input.charAt(i) != ',') {
                    throw new ParseException("XU.ERROR.10054", null, null);
                }
                ++i;
                while (i < length && Character.isWhitespace(input.charAt(i))) {
                    ++i;
                }
                if (i == length) {
                    throw new ParseException("XU.ERROR.10055", null, null);
                }
            }
            startLine = false;
            if (input.charAt(i) != '{') {
                throw new ParseException("XU.ERROR.10058", null, null);
            }
            int start = ++i;
            int nbEscape = 0;
            while (i < length && (input.charAt(i) != '}' || (nbEscape & 1) > 0)) {
                nbEscape = input.charAt(i) == '\\' ? ++nbEscape : 0;
                ++i;
            }
            if (i == length) {
                throw new ParseException("XU.ERROR.10057", null, null);
            }
            if ((className = input.substring(start, end = i++)).length() == 0) {
                throw new ParseException("XU.ERROR.10056", null, null);
            }
            Map<String, String> props = PropertiesConverter.toMap(className);
            PluginConfigImpl plugin = new PluginConfigImpl();
            plugin.setProperties(props);
            list.add(plugin);
        }
        return list;
    }
}

