/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.engine.cre.internal;

import com.ibm.rules.res.xu.bom.internal.BOMConverter;
import com.ibm.rules.res.xu.bom.internal.BOMConverterBase;
import com.ibm.rules.res.xu.bom.internal.DocumentBuilderPool;
import com.ibm.rules.res.xu.bom.internal.TransformerPool;
import com.ibm.rules.res.xu.client.internal.XUWarningListener;
import com.ibm.rules.res.xu.engine.cre.internal.CREEngine;
import com.ibm.rules.res.xu.engine.internal.BOMParameterXMLFilter;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import ilog.rules.bom.IlrObjectModel;
import ilog.rules.engine.IlrContext;
import ilog.rules.engine.IlrRuleset;
import ilog.rules.engine.dataio.IlrBusinessDataXmlService;
import ilog.rules.engine.dataio.IlrTranslatedDataAccessStrategy;
import ilog.rules.factory.IlrDataAccessStrategy;
import ilog.rules.factory.IlrReflect;
import ilog.rules.factory.IlrUnknownValueException;
import ilog.rules.factory.translation.IlrTranslationCompiler;
import ilog.rules.factory.translation.IlrTranslationDebugSupport;
import ilog.rules.res.xu.pool.IlrPoolException;
import ilog.rules.util.issue.IlrErrorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.xpath.XPathException;
import org.w3c.dom.Document;

public final class CREBOMConverter
extends BOMConverterBase {
    private final IlrBusinessDataXmlService service;
    private final DocumentBuilderPool docPool;
    private final TransformerPool trPool;

    private CREBOMConverter(IlrBusinessDataXmlService service, DocumentBuilderPool pool, TransformerPool trPool, LogHandler log) {
        super(log);
        this.trPool = trPool;
        this.docPool = pool;
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOMConverter createBOMConverter(IlrContext context, DocumentBuilderPool pool, TransformerPool transformerPool, LogHandler log) throws XUException {
        Class<CREBOMConverter> clazz = CREBOMConverter.class;
        synchronized (CREBOMConverter.class) {
            IlrRuleset ruleset = context.getRuleset();
            IlrTranslationDebugSupport debug = CREEngine.getTranslationDebugSupport(ruleset);
            IlrReflect bom = CREEngine.getBOMReflect(ruleset);
            IlrReflect xom = ruleset.getReflect();
            IlrTranslationCompiler compiler = debug.getCompiler();
            IlrTranslatedDataAccessStrategy strategy = new IlrTranslatedDataAccessStrategy((IlrObjectModel)bom, xom, context, compiler);
            IlrBusinessDataXmlService srv = new IlrBusinessDataXmlService((IlrObjectModel)bom, (IlrDataAccessStrategy)strategy);
            // ** MonitorExit[var11_4] (shouldn't be in output)
            return new CREBOMConverter(srv, pool, transformerPool, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document createEmptyDocument(boolean roFields) throws IlrPoolException {
        Document doc;
        DocumentBuilder builder;
        DocumentBuilderPool documentBuilderPool = this.docPool;
        synchronized (documentBuilderPool) {
            builder = (DocumentBuilder)this.docPool.get();
            this.docPool.use(builder);
        }
        documentBuilderPool = this.service;
        synchronized (documentBuilderPool) {
            doc = this.service.createEmptyDocument(builder);
        }
        builder.reset();
        documentBuilderPool = this.docPool;
        synchronized (documentBuilderPool) {
            this.docPool.release(builder);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document toDocument(String name, Object o, List<String> filters, boolean roAtts) throws XUException {
        ArrayList<String> paramFilters = new ArrayList<String>();
        if (filters != null) {
            String filterPrefix = name + ".";
            for (String f : filters) {
                if (!f.startsWith(filterPrefix)) continue;
                paramFilters.add(f.substring(filterPrefix.length()));
            }
        }
        try {
            Document doc = this.createEmptyDocument(roAtts);
            IlrBusinessDataXmlService i$ = this.service;
            synchronized (i$) {
                this.service.fillDocument(doc, o, roAtts);
            }
            if (paramFilters.size() > 0) {
                BOMParameterXMLFilter.filter(doc, paramFilters);
            }
            return doc;
        }
        catch (XPathException e) {
            throw new XUException("XU.ERROR.10400", new String[]{name}, (Throwable)e);
        }
        catch (IlrUnknownValueException e) {
            throw new XUException("XU.ERROR.10400", new String[]{name}, (Throwable)e);
        }
    }

    @Override
    public final String toBOM(String name, Object o, List<String> filters, boolean roAtts, BOMConverter.ObjectKind kind, XUWarningListener l) throws XUException {
        switch (kind) {
            case KIND_XML: {
                return this.toXML(name, o, filters, roAtts, l);
            }
            case KIND_JSON: {
                return this.toJSON(name, o, filters, roAtts);
            }
        }
        throw new IllegalArgumentException();
    }

    private String toJSON(String name, Object o, List<String> filters, boolean roAtts) throws XUException {
        throw new UnsupportedOperationException();
    }

    private String toXML(String name, Object o, List<String> filters, boolean roAtts, XUWarningListener l) throws XUException {
        StringWriter writer = new StringWriter();
        try {
            Document doc = this.toDocument(name, o, filters, roAtts);
            this.writeDocument(doc, writer, l);
            String string = writer.toString();
            return string;
        }
        catch (TransformerConfigurationException e) {
            throw new XUException("XU.ERROR.10400", new String[]{name}, (Throwable)e);
        }
        catch (IlrUnknownValueException e) {
            throw new XUException("XU.ERROR.10400", new String[]{name}, (Throwable)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(Document doc, StringWriter writer, XUWarningListener l) throws IlrPoolException, TransformerConfigurationException {
        Transformer tr;
        TransformerPool transformerPool = this.trPool;
        synchronized (transformerPool) {
            tr = (Transformer)this.trPool.get();
            this.trPool.use(tr);
        }
        transformerPool = this.service;
        synchronized (transformerPool) {
            this.service.writeDocument(doc, (Writer)writer, tr);
            CREBOMConverter.fireWarnings(this.service.getWarnings(), l);
        }
        transformerPool = this.trPool;
        synchronized (transformerPool) {
            this.trPool.release(tr);
        }
    }

    @Override
    public final synchronized Object toXOM(String name, String bomString, BOMConverter.ObjectKind kind, XUWarningListener l) throws XUException {
        switch (kind) {
            case KIND_JSON: {
                return this.jsonToXOM(name, bomString, kind);
            }
            case KIND_XML: {
                return this.xmlToXOM(name, bomString, kind, l);
            }
        }
        throw new IllegalArgumentException();
    }

    private Object jsonToXOM(String name, String bomString, BOMConverter.ObjectKind kind) throws XUException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object xmlToXOM(String name, String bomString, BOMConverter.ObjectKind kind, XUWarningListener l) throws XUException {
        StringReader reader = null;
        try {
            Object o;
            reader = new StringReader(bomString);
            Object object = this.service;
            synchronized (object) {
                o = this.service.read((Reader)reader, "bomParameter");
                CREBOMConverter.fireWarnings(this.service.getWarnings(), l);
            }
            object = o;
            return object;
        }
        catch (IlrErrorException e) {
            throw new XUException("XU.ERROR.10400", new String[]{name}, (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

