/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.info.internal;

import com.ibm.rules.res.persistence.internal.PersistencePropertiesConverter;
import com.ibm.rules.res.xu.client.info.internal.EventListenerInfo;
import com.ibm.rules.res.xu.client.info.internal.RulesetArchiveInformationCacheInfo;
import com.ibm.rules.res.xu.client.info.internal.RulesetCacheEntryInfo;
import com.ibm.rules.res.xu.client.info.internal.RulesetParsingWorkInfo;
import com.ibm.rules.res.xu.client.info.internal.SPIConnectionInfo;
import com.ibm.rules.res.xu.client.info.internal.SolvedRulesetPathInfo;
import com.ibm.rules.res.xu.client.info.internal.XUInfo;
import com.ibm.rules.res.xu.info.internal.Converter;
import com.ibm.rules.res.xu.info.internal.JSON;
import com.ibm.rules.res.xu.info.internal.RulesetCacheEntryInfoImpl;
import com.ibm.rules.res.xu.info.internal.SystemInfo;
import com.ibm.rules.res.xu.info.internal.XMLObjectServiceInfo;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformation;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class JSONConverter
extends Converter {
    public static String toJSON(XUInfo info, LogHandler logger) {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        JSON.append(buf, "format-version", "1.0");
        buf.append(',');
        JSON.append(buf, "wodm-version", "8.7.1.0");
        buf.append(',');
        JSON.append(buf, "wodm-build-date", "2015-04-17 13:41:58");
        buf.append(',');
        JSON.append(buf, "date", info.getDate().getTime());
        buf.append(",\"system\":");
        SystemInfo.appendJSON(buf, logger);
        buf.append(",\"properties\":");
        Properties props = info.getSPIFactoryProperties();
        JSON.append(buf, JSONConverter.obfuscateXUProperties(props));
        buf.append(',');
        JSON.append(buf, "cci-reconnection-pool-size", info.getCCIReconectionPoolSize());
        buf.append(",\"ruleset-cache\":{");
        buf.append("\"rulesets\":");
        buf.append(JSONConverter.rulesetCacheToJSON(info.getRulesetCacheEntryInfos()));
        buf.append(",\"deprecated-rulesets\":");
        buf.append(JSONConverter.rulesetCacheToJSON(info.getRulesetCacheDeprecatedEntryInfos()));
        buf.append("}");
        buf.append(",\"ruleset-path-cache\":");
        buf.append(JSONConverter.rulesetPathCacheToJSON(info.getSolvedRulesetPathCache()));
        buf.append(",\"persistence\":{");
        JSON.append(buf, "class-name", info.getRulesetArchiveProviderClass());
        buf.append(',');
        JSON.append(buf, "is-concurrent", info.isConcurrentPersistence());
        buf.append(',');
        JSON.append(buf, "properties", PersistencePropertiesConverter.obfuscate(info.getRulesetArchiveProviderProperties()));
        buf.append("}");
        buf.append(",\"spi-connection-pool\":");
        buf.append(JSONConverter.spiConnPoolToJSON(info.getSPIConnectionInfos()));
        buf.append(",\"event-listeners\":");
        buf.append(JSONConverter.eventListenersToJSON(info.getEventListeners()));
        buf.append(",\"works\":");
        buf.append(JSONConverter.worksToJSON(info.getRulesetParsingWorkInfos()));
        buf.append(",\"ruleset-archive-information-cache\":");
        buf.append(JSONConverter.rulesetArchiveCacheToJSON(info.getRulesetArchiveInformationCacheInfo()));
        buf.append(",\"rulesets-usage\":");
        buf.append(JSONConverter.rulesetUsageToJSON(info.getRulesetUsageInformation()));
        buf.append('}');
        return buf.toString();
    }

    protected static String rulesetUsageToJSON(Map<String, IlrRulesetUsageInformation> entries) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        boolean first = true;
        for (Map.Entry<String, IlrRulesetUsageInformation> entry : entries.entrySet()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append('{');
            JSON.append(buf, "canonical-path", entry.getKey());
            buf.append(',');
            Map<String, Object> props = ((IlrRulesetUsageInformationImpl)entry.getValue()).toMap();
            JSON.append(buf, "properties", props);
            buf.append('}');
        }
        buf.append(']');
        return buf.toString();
    }

    protected static String rulesetArchiveCacheToJSON(RulesetArchiveInformationCacheInfo cache) {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        JSON.append(buf, "rulesets", cache.getRulesetPaths().toArray());
        buf.append(',');
        JSON.append(buf, "deprecated-rulesets", cache.getDeprecatedRulesetPaths().toArray());
        buf.append('}');
        return buf.toString();
    }

    protected static String worksToJSON(Collection<RulesetParsingWorkInfo> works) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        boolean first = true;
        for (RulesetParsingWorkInfo w : works) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append('{');
            JSON.append(buf, "path", w.getRulesetPath());
            buf.append(',');
            JSON.append(buf, "state", w.getState());
            buf.append('}');
        }
        buf.append(']');
        return buf.toString();
    }

    protected static String eventListenersToJSON(ArrayList<EventListenerInfo> listeners) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        boolean first = true;
        for (EventListenerInfo l : listeners) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append('{');
            JSON.append(buf, "mask", l.getMask());
            buf.append(',');
            JSON.append(buf, "ref", l.getRef().toString());
            buf.append('}');
        }
        buf.append(']');
        return buf.toString();
    }

    protected static String spiConnPoolToJSON(Collection<SPIConnectionInfo> entries) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        boolean first = true;
        for (SPIConnectionInfo entry : entries) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append('{');
            JSON.append(buf, "path", entry.getRulesetPath());
            buf.append(',');
            JSON.append(buf, "id", entry.getId());
            buf.append(',');
            JSON.append(buf, "state", entry.getState());
            buf.append(',');
            JSON.append(buf, "type", entry.getType());
            buf.append(',');
            JSON.append(buf, "ref", entry.getRef());
            buf.append(',');
            JSON.append(buf, "free-engines-count", entry.getFreeEngineManagersCount());
            buf.append('}');
        }
        buf.append(']');
        return buf.toString();
    }

    protected static String rulesetPathCacheToJSON(Collection<SolvedRulesetPathInfo> entries) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        boolean first = true;
        for (SolvedRulesetPathInfo entry : entries) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append('{');
            JSON.append(buf, "path", entry.getRulesetPath());
            buf.append(',');
            JSON.append(buf, "canonical-path", entry.getCanonicalRulesetPath());
            buf.append('}');
        }
        buf.append(']');
        return buf.toString();
    }

    protected static String rulesetCacheToJSON(Collection<RulesetCacheEntryInfo> entries) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        boolean first = true;
        for (RulesetCacheEntryInfo entry : entries) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            XMLObjectServiceInfo service = ((RulesetCacheEntryInfoImpl)entry).getXMLObjectService();
            buf.append('{');
            JSON.append(buf, "canonical-path", entry.getCanonicalRulesetPath());
            buf.append(',');
            JSON.append(buf, "is-weak-ref", entry.isWeakReferenced());
            buf.append(',');
            JSON.append(buf, "ref", entry.getRulesetRef());
            buf.append(',');
            JSON.append(buf, "is-de-ruleset", entry.isDERuleset());
            if (entry.getRulesetRef() != null) {
                buf.append(',');
                JSON.append(buf, "xml-converter-pool", JSONConverter.xmlServiceToJSON(service));
            }
            buf.append('}');
        }
        buf.append(']');
        return buf.toString();
    }

    protected static String xmlServiceToJSON(XMLObjectServiceInfo srv) {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        JSON.append(buf, "size", srv.getPoolSize());
        buf.append(',');
        JSON.append(buf, "timeout", srv.getReserveTimeout());
        buf.append(',');
        JSON.append(buf, "max-size", srv.getPoolMaxSize());
        buf.append('}');
        return buf.toString();
    }
}

