/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.info.internal;

import com.ibm.rules.res.xu.info.internal.JSON;
import com.ibm.rules.res.xu.info.internal.XML;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import ilog.rules.monitor.IlrXUMonitorTool;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class SystemInfo {
    protected static IlrXUMonitorTool monitorTool = null;

    public static void appendXML(StringBuffer buf, LogHandler logger) {
        long gcTime;
        try {
            gcTime = SystemInfo.getGarbageCollectionTime();
        }
        catch (Exception e) {
            logger.severe("XU.ERROR.10602", e, null, null);
            gcTime = -1L;
        }
        Runtime runtime = Runtime.getRuntime();
        Properties props = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
        buf.append("<system available-processors='" + runtime.availableProcessors() + "'" + ">\n");
        buf.append("<memory free='" + runtime.freeMemory() + "'" + " max='" + runtime.maxMemory() + "'" + " total='" + runtime.totalMemory() + "'" + " gc-time='" + gcTime + "'" + "/>");
        XML.append(buf, props);
        try {
            buf.append(SystemInfo.threadsInfoToXML());
        }
        catch (Throwable e) {
            logger.severe("XU.ERROR.10602", e, null, null);
        }
        buf.append("</system>\n");
    }

    public static void appendJSON(StringBuffer buf, LogHandler logger) {
        long gcTime;
        try {
            gcTime = SystemInfo.getGarbageCollectionTime();
        }
        catch (Exception e) {
            logger.severe("XU.ERROR.10602", e, null, null);
            gcTime = -1L;
        }
        Properties props = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
        Runtime runtime = Runtime.getRuntime();
        buf.append('{');
        JSON.append(buf, "available-processors", runtime.availableProcessors());
        buf.append(',');
        JSON.append(buf, "memory-free", runtime.freeMemory());
        buf.append(',');
        JSON.append(buf, "memory-max", runtime.maxMemory());
        buf.append(',');
        JSON.append(buf, "memory-total", runtime.totalMemory());
        buf.append(',');
        JSON.append(buf, "gc-time", gcTime);
        buf.append(", \"properties\":");
        JSON.append(buf, props);
        buf.append('}');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final long getGarbageCollectionTime() throws IlrXUMonitorTool.XUMonitorToolException {
        long gcTime = 0L;
        Class<SystemInfo> clazz = SystemInfo.class;
        synchronized (SystemInfo.class) {
            long[] times = SystemInfo.getMonitorTool().getGarbageCollectionTime();
            for (int i = 0; i < times.length; ++i) {
                gcTime += times[i];
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return gcTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final IlrXUMonitorTool getMonitorTool() throws IlrXUMonitorTool.XUMonitorToolException {
        Class<SystemInfo> clazz = SystemInfo.class;
        synchronized (SystemInfo.class) {
            if (monitorTool == null) {
                monitorTool = new IlrXUMonitorTool();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return monitorTool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String threadsInfoToXML() throws IlrXUMonitorTool.XUMonitorToolException {
        Class<SystemInfo> clazz = SystemInfo.class;
        synchronized (SystemInfo.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return SystemInfo.getMonitorTool().getDump(new Properties());
        }
    }
}

