/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.info.internal;

import com.ibm.rules.res.xu.info.internal.XUInfoSchedulerWork;
import ilog.rules.res.xu.spi.IlrManagedXUConnectionFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;

public class XUInfoScheduler {
    protected boolean enabled = false;
    protected long interval = 10000L;
    protected WorkManager workMgr;
    protected final IlrManagedXUConnectionFactory factory;
    protected XUInfoSchedulerWork work;

    public XUInfoScheduler(IlrManagedXUConnectionFactory factory) {
        this.factory = factory;
    }

    public final synchronized void setEnabled(boolean enabled) throws WorkException {
        if (this.enabled && !enabled) {
            this.stopWork();
        }
        if (!this.enabled && enabled) {
            this.startWork();
        }
        this.enabled = enabled;
    }

    public final synchronized void setInterval(long interval) {
        this.interval = interval;
        if (this.work != null) {
            this.work.setInterval(interval);
        }
    }

    public final synchronized boolean isEnabled() {
        return this.enabled;
    }

    public final synchronized long getInterval() {
        return this.interval;
    }

    public final synchronized void setWorkManager(WorkManager workMgr) throws WorkException {
        this.workMgr = workMgr;
        if (this.enabled) {
            this.startWork();
        }
    }

    protected final void startWork() throws WorkException {
        if (this.workMgr == null || this.work != null) {
            return;
        }
        this.work = new XUInfoSchedulerWork(this.interval, this.factory);
        this.workMgr.startWork((Work)this.work);
    }

    protected final void stopWork() {
        if (this.work == null) {
            return;
        }
        this.work.release();
        this.work = null;
    }
}

