/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.log.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

final class WriterHandler
extends Handler {
    private final Writer writer;

    public WriterHandler(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            Logger.global.log(Level.SEVERE, "XU Failed to close log", e);
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            Logger.global.log(Level.SEVERE, "XU Failed to flush log", e);
        }
    }

    @Override
    public void publish(LogRecord record) {
        Formatter formatter = this.getFormatter();
        try {
            this.writer.write(formatter.format(record));
        }
        catch (IOException e) {
            Logger.global.log(Level.SEVERE, "XU Failed to publish log record", e);
        }
    }
}

