/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.log.internal;

import com.ibm.rules.res.logging.internal.XULogRecord;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import ilog.rules.engine.IlrFlowTask;
import ilog.rules.engine.IlrFunctionTask;
import ilog.rules.engine.IlrRuleInstance;
import ilog.rules.engine.IlrRuleTask;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.cci.IlrConnectionContext;
import ilog.rules.res.xu.cci.IlrConnectionId;
import ilog.rules.res.xu.spi.IlrManagedConnectionContext;
import ilog.rules.res.xu.spi.IlrManagedXUConnectionContext;
import java.io.Serializable;
import java.util.logging.Level;

public class XULogRecordFactory {
    private XULogRecordFactory() {
    }

    public static final XULogRecord createXULogRecord(Level level, String key, Throwable throwable, Object[] params, IlrXUContext xuContext) {
        XULogRecord rec = new XULogRecord(level, key, XULogRecordFactory.formatParameters(params), "com.ibm.rules.res.xu.messages", LocalizedMessageHelper.getResourceBundle("com.ibm.rules.res.xu.messages"), XULogRecordFactory.getRulesetPath(xuContext), XULogRecordFactory.getUserData(xuContext), XULogRecordFactory.getCCIConnectionId(xuContext), XULogRecordFactory.getSPIConnectionId(xuContext));
        rec.setLoggerName("com.ibm.rules.res.execution");
        rec.setThrown(throwable);
        return rec;
    }

    protected static final Object[] formatParameters(Object[] params) {
        if (params == null || params.length == 0) {
            return params;
        }
        Object[] result = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object p = params[i];
            if (p == null) continue;
            result[i] = p instanceof IlrRuleInstance ? ((IlrRuleInstance)p).getRuleName() : (p instanceof IlrRuleTask ? ((IlrRuleTask)p).getName() : (p instanceof IlrFunctionTask ? ((IlrFunctionTask)p).getName() : (p instanceof IlrFlowTask ? ((IlrFlowTask)p).getName() : p)));
        }
        return result;
    }

    protected static final String getRulesetPath(IlrXUContext context) {
        if (context == null) {
            return null;
        }
        if (context instanceof IlrManagedXUConnectionContext) {
            return ((IlrManagedXUConnectionContext)context).getRulesetPath();
        }
        IlrConnectionContext connectionContext = null;
        if (context instanceof IlrManagedConnectionContext) {
            IlrManagedConnectionContext managedConnectionContext = (IlrManagedConnectionContext)context;
            connectionContext = managedConnectionContext.getConnectionContext();
        } else if (context instanceof IlrConnectionContext) {
            connectionContext = (IlrConnectionContext)context;
        }
        if (connectionContext != null && connectionContext.getConnectionInformation() != null) {
            return connectionContext.getConnectionInformation().getConnectionSpec().getRulesetPath();
        }
        return null;
    }

    protected static final String getUserData(IlrXUContext context) {
        Serializable data;
        if (context == null) {
            return null;
        }
        IlrConnectionContext connectionContext = null;
        if (context instanceof IlrManagedConnectionContext) {
            IlrManagedConnectionContext managedConnectionContext = (IlrManagedConnectionContext)context;
            connectionContext = managedConnectionContext.getConnectionContext();
        } else if (context instanceof IlrConnectionContext) {
            connectionContext = (IlrConnectionContext)context;
        }
        if (connectionContext != null && connectionContext.getConnectionInformation() != null && (data = connectionContext.getConnectionInformation().getConnectionSpec().getUserData()) != null) {
            return data.toString();
        }
        return null;
    }

    protected static final String getCCIConnectionId(IlrXUContext context) {
        IlrConnectionId id;
        if (context == null) {
            return null;
        }
        IlrConnectionContext connectionContext = null;
        if (context instanceof IlrManagedConnectionContext) {
            IlrManagedConnectionContext managedConnectionContext = (IlrManagedConnectionContext)context;
            connectionContext = managedConnectionContext.getConnectionContext();
        } else if (context instanceof IlrConnectionContext) {
            connectionContext = (IlrConnectionContext)context;
        }
        if (connectionContext != null && connectionContext.getConnectionInformation() != null && (id = connectionContext.getConnectionInformation().getConnectionId()) != null) {
            return id.toString();
        }
        return null;
    }

    protected static final String getSPIConnectionId(IlrXUContext context) {
        IlrConnectionId id;
        if (context == null) {
            return null;
        }
        if (context instanceof IlrManagedXUConnectionContext) {
            IlrConnectionId id2 = ((IlrManagedXUConnectionContext)context).getConnectionId();
            if (id2 == null) {
                return null;
            }
            return id2.toString();
        }
        IlrConnectionContext connectionContext = null;
        if (context instanceof IlrManagedConnectionContext) {
            IlrManagedConnectionContext managedConnectionContext = (IlrManagedConnectionContext)context;
            connectionContext = managedConnectionContext.getConnectionContext();
        } else if (context instanceof IlrConnectionContext) {
            connectionContext = (IlrConnectionContext)context;
        }
        if (connectionContext != null && connectionContext.getConnectionInformation() != null && (id = connectionContext.getConnectionInformation().getSPIConnectionId()) != null) {
            return id.toString();
        }
        return null;
    }
}

