/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.management;

import com.ibm.rules.res.message.internal.XXBrokerMessageCode;
import com.ibm.rules.res.notificationserver.NotificationServerClient;
import com.ibm.rules.res.notificationserver.NotificationServerClientFactory;
import com.ibm.rules.res.xu.management.XUMonitoringPlugin;
import ilog.rules.res.util.lang.IlrClassPrivilegedAction;
import ilog.rules.res.xu.persistence.IlrFilePersistence;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;

public class RESManagementServerClient
extends Thread
implements Work {
    private XUMonitoringPlugin monitoringPlugin = null;
    private String resManagementServerHost = null;
    private Integer resManagementServerPort = null;
    private Long resManagementReconnectionInterval = null;
    private String xuLocationInformation = null;
    private NotificationServerClient client = null;
    private Properties xuProperties = null;

    public RESManagementServerClient(String resManagementServerHost, Integer resManagementServerPort, long resManagementServerReconnectionInterval, String xuLocationInformation, Properties xuProperties, XUMonitoringPlugin monitoringPlugin) {
        this.resManagementServerHost = resManagementServerHost;
        this.resManagementServerPort = resManagementServerPort;
        this.resManagementReconnectionInterval = resManagementServerReconnectionInterval;
        this.xuLocationInformation = xuLocationInformation;
        this.xuProperties = xuProperties;
        this.monitoringPlugin = monitoringPlugin;
    }

    @Override
    public void run() {
        try {
            String persistenceType;
            String clientID = UUID.randomUUID().toString();
            Properties clientProperties = new Properties();
            clientProperties.setProperty("xuName", clientID);
            clientProperties.setProperty("xuVersion", "8.7.1.0");
            clientProperties.setProperty("xuUpdate", "1");
            String s = System.getProperty("hbr.xulocation");
            if (s != null && s.startsWith("CICS")) {
                clientProperties.setProperty("cics", "true");
            }
            if ((persistenceType = this.xuProperties.getProperty("persistenceType")) != null && !IlrFilePersistence.class.getName().equals(persistenceType)) {
                clientProperties.setProperty("persistenceType", persistenceType);
            } else {
                this.monitoringPlugin.log(Level.FINE, XXBrokerMessageCode.WARNING_NO_VALUE_DEFINED_FOR_PROPERTY, new String[]{"persistenceType"});
            }
            String persistenceProperties = this.xuProperties.getProperty("persistenceProperties");
            if (persistenceProperties != null) {
                clientProperties.setProperty("persistenceProperties", persistenceProperties);
            } else {
                ClassLoader cl = IlrClassPrivilegedAction.getClassLoader(this.getClass());
                String notAvailableMessage = "persistenceProperties is not available";
                clientProperties.setProperty("persistenceProperties", notAvailableMessage);
                this.monitoringPlugin.log(Level.FINE, XXBrokerMessageCode.WARNING_BROKER_PLUGIN_PROPERTY, new String[]{"persistenceProperties = null"});
            }
            if (this.xuLocationInformation != null) {
                clientProperties.setProperty("notification.server.client.location", this.xuLocationInformation);
            }
            StringBuffer clientPropertiesAsString = new StringBuffer();
            for (Object key : clientProperties.keySet()) {
                clientPropertiesAsString.append(key);
                clientPropertiesAsString.append(": ");
                clientPropertiesAsString.append(clientProperties.get(key));
                clientPropertiesAsString.append(". ");
            }
            this.monitoringPlugin.log(Level.FINE, XXBrokerMessageCode.INFO_BROKER_PLUGIN_CREATING_CLIENT_WITH_PROPERTIES, new String[]{clientPropertiesAsString.toString()});
            this.client = NotificationServerClientFactory.getInstance().createNotificationServerClient(clientID, clientProperties, new URI("ns://" + this.resManagementServerHost + ":" + this.resManagementServerPort), this.monitoringPlugin, this.resManagementReconnectionInterval, new RESManagementServerClientLogger(this.monitoringPlugin), new WorkManagerThreadFactory(this.monitoringPlugin.getWorkManager()));
            this.client.connect();
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            String stack = stringWriter.toString();
            this.monitoringPlugin.log(Level.SEVERE, XXBrokerMessageCode.ERROR_BROKER_PLUGIN_FAILEDSTART, new String[]{e.getClass().getName(), stack});
        }
    }

    public void release() {
    }

    public void disconnectAndCleanup() {
        if (this.client != null) {
            this.client.disconnect();
        }
        this.client = null;
        this.monitoringPlugin.log(Level.FINE, XXBrokerMessageCode.INFO_BROKER_PLUGIN_STOPPED, null);
    }

    private class WorkManagerThreadFactory
    implements ThreadFactory {
        WorkManager workManager = null;

        public WorkManagerThreadFactory(WorkManager workManager) {
            if (workManager == null) {
                throw new IllegalArgumentException();
            }
            this.workManager = workManager;
        }

        @Override
        public Thread newThread(Runnable target) {
            return new WorkThread(this.workManager, target);
        }
    }

    private class WorkThread
    extends Thread
    implements Work {
        private WorkManager workManager;

        public WorkThread(WorkManager workManager, Runnable target) {
            super(target);
            this.workManager = null;
            if (workManager == null) {
                throw new IllegalArgumentException();
            }
            this.workManager = workManager;
        }

        @Override
        public synchronized void start() {
            try {
                this.workManager.startWork((Work)this);
            }
            catch (WorkException e) {
                throw new RuntimeException(e);
            }
        }

        public void release() {
        }
    }

    private class RESManagementServerClientLogger
    extends Logger {
        private XUMonitoringPlugin xuPlugin;

        public RESManagementServerClientLogger(XUMonitoringPlugin theXUPlugin) {
            super(null, null);
            this.xuPlugin = null;
            if (theXUPlugin == null) {
                throw new IllegalArgumentException();
            }
            this.xuPlugin = theXUPlugin;
        }

        @Override
        public void log(LogRecord record) {
            record.setLoggerName("com.ibm.rules.res.mbean");
            this.xuPlugin.log(record);
        }

        @Override
        public boolean isLoggable(Level level) {
            return true;
        }
    }
}

