/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.management;

import com.ibm.rules.res.logging.internal.XULogRecord;
import com.ibm.rules.res.management.internal.XUManagementPluginInternalProperties;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.message.internal.XXBrokerMessageCode;
import com.ibm.rules.res.notificationserver.Message;
import com.ibm.rules.res.notificationserver.NotificationHandler;
import com.ibm.rules.res.persistence.internal.PersistencePropertiesConverter;
import com.ibm.rules.res.xu.config.internal.PersistenceConfig;
import com.ibm.rules.res.xu.config.internal.XUConfig;
import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogListener;
import com.ibm.rules.res.xu.management.RESManagementServerClient;
import com.ibm.rules.res.xu.management.XUManagementPluginInteractionExtension;
import com.ibm.rules.res.xu.plugin.Plugin;
import com.ibm.rules.res.xu.plugin.PluginException;
import ilog.rules.res.mbean.util.IlrMBeanManager;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.util.lang.IlrClassPrivilegedAction;
import ilog.rules.res.xu.cci.IlrInteractionExtension;
import ilog.rules.res.xu.management.IlrXULogEvent;
import ilog.rules.res.xu.management.IlrXUMonitoringMBean;
import ilog.rules.res.xu.management.IlrXURulesetLogs;
import ilog.rules.res.xu.management.XUMBeanFactory;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformation;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformationMonitor;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;

public class XUMonitoringPlugin
extends Plugin
implements LogListener,
NotificationHandler,
XUManagementPluginInternalProperties {
    static final String RESOURCE_BUNDLE_NAME = "com.ibm.rules.res.xu.management.plugin";
    private boolean connectToRESManagementServer = "jmx".equals("tcpip");
    private String resManagementServerHost = "localhost";
    private int resManagementServerPort = 1883;
    private long resManagementServerReconnectionInterval = 1000L;
    private String xuLocationInformation = null;
    private RESManagementServerClient resManagementServerClient = null;
    protected XUMBeanFactory mbeanFactory = null;
    protected String xuName = null;
    private IlrMBeanManager mbeanManager = null;
    private IlrXUMonitoringMBean mbean = null;
    private ObjectName objectName = null;
    private final Map<String, IlrXURulesetInfos> rulesets = new Hashtable<String, IlrXURulesetInfos>();
    private Properties properties = new Properties();
    private Queue<IlrPath> rulesetUpdateNotificationsQueue = null;
    private final XUManagementPluginInteractionExtension extension = new XUManagementPluginInteractionExtension(this);

    public void log(Level logLevel, String keyMessage, Object[] parameters) {
        this.log(logLevel, keyMessage, parameters, null);
    }

    public void log(Level logLevel, String keyMessage, Object[] parameters, Throwable thrown) {
        this.log(RESOURCE_BUNDLE_NAME, logLevel, keyMessage, parameters, thrown);
    }

    protected void log(String bundleName, Level logLevel, String keyMessage, Object[] parameters, Throwable thrown) {
        ClassLoader cl = IlrClassPrivilegedAction.getClassLoader(this.getClass());
        LogRecord record = new LogRecord(logLevel, LocalizedMessageHelper.getLocalizedMessage(bundleName, keyMessage, parameters, Locale.getDefault(), cl, true));
        record.setLoggerName("com.ibm.rules.res.mbean");
        if (thrown != null) {
            record.setThrown(thrown);
        }
        this.log(record);
    }

    @Override
    public void start(Map<String, String> props) throws PluginException {
        if (props != null) {
            this.properties = new Properties();
            for (String key : props.keySet()) {
                this.properties.setProperty(key, props.get(key));
            }
            if (this.properties.getProperty("protocol") != null && this.properties.getProperty("protocol").toString().equalsIgnoreCase("tcpip")) {
                this.connectToRESManagementServer = true;
            }
            if (this.connectToRESManagementServer) {
                String locationSystemPropertyName;
                if (this.properties.containsKey("tcpip.host")) {
                    this.resManagementServerHost = this.properties.getProperty("tcpip.host");
                }
                if (this.properties.containsKey("tcpip.port")) {
                    try {
                        this.resManagementServerPort = Integer.valueOf(this.properties.getProperty("tcpip.port"));
                    }
                    catch (NumberFormatException e) {
                        this.log(new XULogRecord(Level.SEVERE, XXBrokerMessageCode.ERROR_BROKER_PLUGIN_PARSEINTVALUE, new String[]{this.properties.getProperty("tcpip.port"), String.valueOf(this.resManagementServerPort)}, RESOURCE_BUNDLE_NAME, null, null, null, null, null));
                        this.log(Level.SEVERE, XXBrokerMessageCode.ERROR_BROKER_PLUGIN_PARSEINTVALUE, new String[]{this.properties.getProperty("tcpip.port"), String.valueOf(this.resManagementServerPort)}, e);
                    }
                }
                if (this.properties.containsKey("tcpip.retryInterval")) {
                    try {
                        this.resManagementServerReconnectionInterval = Integer.valueOf(this.properties.getProperty("tcpip.retryInterval")).intValue();
                    }
                    catch (NumberFormatException e) {
                        this.log(Level.SEVERE, XXBrokerMessageCode.ERROR_BROKER_PLUGIN_PARSEINTVALUE, new String[]{this.properties.getProperty("tcpip.retryInterval"), String.valueOf(this.resManagementServerReconnectionInterval)}, e);
                    }
                }
                if (this.properties.containsKey("tcpip.location.property") && (locationSystemPropertyName = this.properties.getProperty("tcpip.location.property")) != null) {
                    this.xuLocationInformation = System.getProperty(locationSystemPropertyName);
                }
            } else {
                String xuName = this.properties.containsKey("jmx.xuName") ? this.properties.getProperty("jmx.xuName") : this.properties.getProperty("xuName");
                this.setXuName(xuName);
            }
        }
        if (this.connectToRESManagementServer) {
            this.connectToRESManagementServer();
        } else {
            this.registerAsMBean();
        }
    }

    @Override
    public IlrInteractionExtension getInteractionExtension() {
        return this.extension;
    }

    @Override
    public void release() {
        if (this.connectToRESManagementServer) {
            if (this.resManagementServerClient != null) {
                try {
                    this.resManagementServerClient.disconnectAndCleanup();
                }
                catch (Throwable t) {
                    this.log("com.ibm.rules.res.xu.messages", Level.SEVERE, "XU.ERROR.10021", new String[0], t);
                }
            }
        } else {
            this.log("com.ibm.rules.res.xu.messages", Level.INFO, "XU.INFO.8003", null, null);
            try {
                this.unregister();
            }
            catch (PluginException e) {
                this.log("com.ibm.rules.res.xu.messages", Level.SEVERE, "XU.ERROR.10027", new String[0], e);
            }
        }
    }

    @Override
    public void recordLogged(LogRecord logRecord) {
        if (logRecord != null) {
            IlrXURulesetInfos rulesetInfos;
            String rulesetPath = "";
            if (logRecord instanceof XULogRecord) {
                XULogRecord xuLogRecord = (XULogRecord)logRecord;
                rulesetPath = xuLogRecord.getRulesetPath();
                try {
                    if (rulesetPath == null || !IlrPath.parsePath(rulesetPath).isCanonical()) {
                        rulesetPath = "";
                    }
                }
                catch (IlrFormatException e) {
                    rulesetPath = "";
                }
            }
            if ((rulesetInfos = this.rulesets.get(rulesetPath)) == null) {
                rulesetInfos = new IlrXURulesetInfos();
                this.rulesets.put(rulesetPath, rulesetInfos);
            }
            rulesetInfos.addLogEvent(logRecord);
        }
    }

    @Override
    public void onNotification(Message theNotification) {
        if ("RULESET_UPDATE".equals(theNotification.getHeader())) {
            try {
                this.onRulesetUpdateNotification(IlrPath.parsePath(theNotification.getData()[0]));
            }
            catch (IlrFormatException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Serializable onRequest(Message theRequest) {
        block42: {
            String messageHeader = theRequest.getHeader();
            if ("TEST_RULESET_EXECUTION".equals(messageHeader)) {
                String returnedValue = null;
                try {
                    Map<String, Object> results = this.executeRuleset(IlrPath.parsePath(theRequest.getData()[0]));
                    returnedValue = (String)results.get("result");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return returnedValue;
            }
            if ("DEBUG_INFOS".equals(messageHeader)) {
                Locale locale = null;
                try {
                    locale = new Locale(theRequest.getData()[0]);
                }
                catch (ClassCastException e) {
                    this.log(Level.WARNING, XXBrokerMessageCode.WARNING_MISSING_LOCALE_IN_INCOMING_MESSAGE, new String[0], e);
                }
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                try {
                    return this.getXUDump(locale);
                }
                catch (XUException e) {
                    this.log(Level.SEVERE, XXBrokerMessageCode.ERROR_MISSING_RULESET_PATH_IN_INCOMING_MESSAGE, new String[0], e);
                    break block42;
                }
            }
            if ("XU_LOGS".equals(messageHeader)) {
                Locale locale = null;
                try {
                    locale = new Locale(theRequest.getData()[0]);
                }
                catch (ClassCastException e) {
                    this.log(Level.WARNING, XXBrokerMessageCode.WARNING_MISSING_LOCALE_IN_INCOMING_MESSAGE, new String[0], e);
                }
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                return this.getLogs(locale);
            }
            if ("WARNING_COUNT".equals(messageHeader)) {
                return Long.valueOf(this.getWarningCount());
            }
            if ("ERROR_COUNT".equals(messageHeader)) {
                return Long.valueOf(this.getErrorCount());
            }
            if ("RESET_XU_LOGS".equals(messageHeader)) {
                this.resetLogs();
                return Boolean.TRUE;
            }
            if ("RULESET_LOGS".equals(messageHeader)) {
                Object[] data = null;
                try {
                    data = theRequest.getData();
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                if (data != null && data.length == 2) {
                    Locale locale = null;
                    try {
                        locale = new Locale((String)data[0]);
                    }
                    catch (ClassCastException e) {
                        this.log(Level.WARNING, XXBrokerMessageCode.WARNING_MISSING_LOCALE_IN_INCOMING_MESSAGE, new String[0], e);
                    }
                    if (locale == null) {
                        locale = Locale.getDefault();
                    }
                    String rulesetPath = null;
                    try {
                        rulesetPath = (String)data[1];
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                    if (rulesetPath != null) {
                        return this.getLogs(locale, rulesetPath);
                    }
                    this.log(Level.SEVERE, XXBrokerMessageCode.ERROR_MISSING_RULESET_PATH_IN_INCOMING_MESSAGE, new String[0]);
                } else {
                    this.log(Level.SEVERE, XXBrokerMessageCode.ERROR_INVALID_DATA_IN_INCOMING_MESSAGE, new String[0]);
                }
            } else if ("RESET_RULESET_LOGS".equals(messageHeader)) {
                String rulesetPath = null;
                try {
                    rulesetPath = theRequest.getData()[0];
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                if (rulesetPath != null) {
                    this.resetLogs(rulesetPath);
                    return Boolean.TRUE;
                }
                this.log(Level.SEVERE, XXBrokerMessageCode.ERROR_MISSING_RULESET_PATH_IN_INCOMING_MESSAGE, new String[0]);
            } else if ("RULESET_STATISTICS".equals(messageHeader)) {
                String rulesetPath = null;
                try {
                    rulesetPath = theRequest.getData()[0];
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                if (rulesetPath != null) {
                    return (HashMap)this.getStatistics(rulesetPath);
                }
                this.log(Level.SEVERE, XXBrokerMessageCode.ERROR_MISSING_RULESET_PATH_IN_INCOMING_MESSAGE, new String[0]);
            } else if ("RESET_RULESET_STATISTICS".equals(messageHeader)) {
                String rulesetPath = null;
                try {
                    rulesetPath = theRequest.getData()[0];
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                if (rulesetPath != null) {
                    this.removeStatistics(rulesetPath);
                    return Boolean.TRUE;
                }
                this.log(Level.SEVERE, XXBrokerMessageCode.ERROR_MISSING_RULESET_PATH_IN_INCOMING_MESSAGE, new String[0]);
            }
        }
        return null;
    }

    @Override
    public void setLogger(Logger logger) {
    }

    public IlrMBeanManager getMBeanManager() {
        return this.mbeanManager;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public IlrXUMonitoringMBean getMBean() {
        return this.mbean;
    }

    public void setRulesetUpdateNotificationQueue(Queue<IlrPath> theRulesetUpdateNotificationQueue) {
        this.rulesetUpdateNotificationsQueue = theRulesetUpdateNotificationQueue;
    }

    public String getAdapterName() {
        return XUInfoImpl.MetaData.getResourceAdapterName();
    }

    public String getAdapterVersion() {
        return XUInfoImpl.MetaData.getVersion();
    }

    public String getAdapterShortDescription() {
        return XUInfoImpl.MetaData.getShortDescription(null);
    }

    public String getAdapterVendorName() {
        return XUInfoImpl.MetaData.getVendorName();
    }

    public Object[] getLogs(Locale locale) {
        return this.getLogs(locale, "");
    }

    public Object[] getLogs(Locale locale, String canonicalRulesetPath) {
        IlrXURulesetInfos rulesetInfos = this.rulesets.get(canonicalRulesetPath);
        if (rulesetInfos != null) {
            return rulesetInfos.getLogEvents(locale);
        }
        return null;
    }

    public void resetLogs() {
        this.resetLogs("");
    }

    public void resetLogs(String canonicalRulesetPath) {
        IlrXURulesetInfos rulesetInfos = this.rulesets.get(canonicalRulesetPath);
        if (rulesetInfos != null) {
            rulesetInfos.resetLogs();
        }
    }

    public long getWarningCount() {
        long warningCount = 0L;
        for (IlrXURulesetInfos rulesetInfos : this.rulesets.values()) {
            warningCount += rulesetInfos.warningCount;
        }
        return warningCount;
    }

    public long getErrorCount() {
        long errorCount = 0L;
        for (IlrXURulesetInfos rulesetInfos : this.rulesets.values()) {
            errorCount += rulesetInfos.errorCount;
        }
        return errorCount;
    }

    public void resetWarnings() {
        for (IlrXURulesetInfos rulesetInfos : this.rulesets.values()) {
            rulesetInfos.resetWarnings();
        }
    }

    public void resetErrors() {
        for (IlrXURulesetInfos rulesetInfos : this.rulesets.values()) {
            rulesetInfos.resetErrors();
        }
    }

    public Map<String, long[]> getStatistics(String canonicalRulesetPath) {
        IlrRulesetUsageInformation usage;
        IlrRulesetUsageInformationMonitor monitor = this.getRulesetUsageInformationMonitor();
        if (monitor != null && (usage = monitor.getRulesetUsageInformation(canonicalRulesetPath)) != null) {
            HashMap<String, long[]> returnedValue = new HashMap<String, long[]>();
            returnedValue.put("1", new long[]{usage.getFirstExecutionTime(), usage.getShortestExecutionDuration(), usage.getExecutionCount(), usage.getLastUsageTime(), usage.getLastExecutionDuration(), usage.getLongestExecutionDuration(), usage.getTotalExecutionDuration()});
            return returnedValue;
        }
        return null;
    }

    public void removeStatistics(String canonicalRulesetPath) {
        IlrRulesetUsageInformation usage;
        IlrRulesetUsageInformationMonitor monitor = this.getRulesetUsageInformationMonitor();
        if (monitor != null && (usage = monitor.getRulesetUsageInformation(canonicalRulesetPath)) != null) {
            ((IlrRulesetUsageInformationImpl)usage).reset();
        }
    }

    public String getXUDump() throws XUException {
        return this.getXUDump(Locale.getDefault());
    }

    public Map<String, Object> executeRuleset(String rulesetPath) throws XUException {
        try {
            return this.executeRuleset(IlrPath.parsePath(rulesetPath));
        }
        catch (IlrFormatException e) {
            throw new XUException("XU.ERROR.10048", e);
        }
    }

    protected void registerAsMBean() throws PluginException {
        this.log("com.ibm.rules.res.xu.messages", Level.INFO, "XU.INFO.8002", null, null);
        try {
            this.mbeanFactory = new XUMBeanFactory(this.properties);
            this.mbeanManager = this.mbeanFactory.getMBeanManager();
            this.mbean = this.createMBean();
            try {
                this.register();
            }
            catch (PluginException e) {
                this.log("com.ibm.rules.res.xu.messages", Level.WARNING, XUMessageCode.WARNING_CANNOT_REGISTER_MBEAN, null, e);
                this.unregister();
                this.register();
            }
        }
        catch (Exception e) {
            throw new PluginException("XU.ERROR.10026", null, (Throwable)e);
        }
    }

    protected IlrXUMonitoringMBean createMBean() {
        return this.mbeanFactory.createXUMonitoringMBean(this);
    }

    protected String getMBeanType() {
        return "IlrXUMonitoring";
    }

    protected Properties getMBeanProperties() {
        Properties props = new Properties();
        props.setProperty("xuId", "IlrXU");
        props.setProperty("xuType", "monitoring");
        props.setProperty("xuVersion", "8.7.1.0");
        props.setProperty("xuUpdate", "1");
        if (this.xuName != null) {
            props.setProperty("xuName", this.xuName);
        }
        return props;
    }

    private void register() throws PluginException {
        this.log("com.ibm.rules.res.xu.messages", Level.FINEST, "XUMBean.register", new Object[]{this.mbeanManager, this.xuName}, null);
        try {
            Properties props = this.getMBeanProperties();
            this.objectName = this.mbeanManager.registerMBean(this.getMBeanType(), props, this.mbean);
        }
        catch (Exception e) {
            throw new PluginException("XU.ERROR.10029", (Object[])new String[]{this.mbeanManager.toString(), this.xuName}, (Throwable)e);
        }
    }

    private void unregister() throws PluginException {
        try {
            if (this.objectName != null) {
                this.log("com.ibm.rules.res.xu.messages", Level.FINEST, "XUMBean.unregister", new Object[]{this.mbeanManager, this.objectName}, null);
                this.mbeanManager.unregisterMBean(this.objectName);
            } else {
                Properties filter = this.getMBeanProperties();
                ObjectName query = this.mbeanManager.getQuery(this.getMBeanType(), filter);
                Set<ObjectName> objectNames = this.mbeanManager.findLocalMBeans(query);
                for (ObjectName on : objectNames) {
                    this.log("com.ibm.rules.res.xu.messages", Level.FINEST, "XUMBean.unregister", new Object[]{this.mbeanManager, on}, null);
                    this.mbeanManager.unregisterMBean(on);
                }
            }
            this.objectName = null;
        }
        catch (Exception e) {
            throw new PluginException("XU.ERROR.10028", (Object[])new String[]{this.mbeanManager.toString(), this.objectName == null ? "<null>" : this.objectName.toString()}, (Throwable)e);
        }
    }

    private void setXuName(String xuName) {
        this.log("com.ibm.rules.res.xu.messages", Level.FINEST, "XUMBean.setProperty", new String[]{"xuName", xuName}, null);
        this.xuName = xuName;
    }

    private Map<String, Object> executeRuleset(IlrPath path) throws XUException {
        return this.executeRuleset(path, new HashMap<String, Object>(), null, true);
    }

    private String getXUDump(Locale theLocale) throws XUException {
        return this.getXUInfo().toXMLString(theLocale);
    }

    protected void connectToRESManagementServer() {
        this.resManagementServerClient = new RESManagementServerClient(this.resManagementServerHost, this.resManagementServerPort, this.resManagementServerReconnectionInterval, this.xuLocationInformation, this.getXuProperties(), this);
        try {
            this.getWorkManager().startWork((Work)this.resManagementServerClient);
        }
        catch (WorkException e) {
            this.log(Level.SEVERE, XXBrokerMessageCode.ERROR_BROKER_PLUGIN_FAILEDSTART, new String[]{e.getMessage()}, e);
        }
    }

    private Properties getXuProperties() {
        try {
            PersistenceConfig persistenceConfig;
            Properties returnedValue = new Properties();
            XUConfig xuConfig = this.getXUConfig();
            if (xuConfig != null && (persistenceConfig = xuConfig.getPersistenceConfig()) != null) {
                Map<String, String> persistenceProperties;
                String type = persistenceConfig.getType();
                if (type != null) {
                    returnedValue.setProperty("persistenceType", type);
                }
                if ((persistenceProperties = persistenceConfig.getProperties()) != null) {
                    persistenceProperties = PersistencePropertiesConverter.obfuscate(persistenceProperties);
                    returnedValue.setProperty("persistenceProperties", persistenceProperties.toString());
                }
            }
            return returnedValue;
        }
        catch (XUException e) {
            this.log(Level.WARNING, XXBrokerMessageCode.ERROR_BROKER_PLUGIN_SENDNOTIF, new String[]{e.getLocalizedMessage()}, e);
            return null;
        }
    }

    protected void onRulesetUpdateNotification(IlrPath theRulesetPath) {
        this.log(Level.INFO, XXBrokerMessageCode.INFO_BROKER_PLUGIN_NOTIFRECEIVED, new String[]{String.valueOf(theRulesetPath)});
        try {
            if (this.rulesetUpdateNotificationsQueue != null) {
                if (!this.rulesetUpdateNotificationsQueue.offer(theRulesetPath)) {
                    throw new XUException();
                }
            } else {
                this.notifyRulesetArchiveChanged(theRulesetPath);
            }
        }
        catch (XUException e) {
            this.log(Level.SEVERE, XXBrokerMessageCode.ERROR_BROKER_PLUGIN_SENDNOTIF, new String[]{theRulesetPath.toString(), e.getLocalizedMessage()}, e);
        }
    }

    private class IlrXURulesetInfos {
        private static final int HISTORIC_LENGTH = 50;
        private LinkedList<IlrXULogEvent> messages = new LinkedList();
        private long warningCount = 0L;
        private long errorCount = 0L;

        private IlrXURulesetInfos() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addLogEvent(LogRecord logRecord) {
            ResourceBundle rb;
            String logRecordMessage;
            if (Level.WARNING.equals(logRecord.getLevel())) {
                ++this.warningCount;
            } else if (Level.SEVERE.equals(logRecord.getLevel())) {
                ++this.errorCount;
            }
            Throwable t = logRecord.getThrown();
            String stack = null;
            if (t != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                pw.close();
                stack = sw.toString();
            }
            if ((logRecordMessage = logRecord.getMessage()) != null && (rb = logRecord.getResourceBundle()) != null) {
                try {
                    String messagePattern = rb.getString(logRecordMessage);
                    logRecordMessage = MessageFormat.format(messagePattern, logRecord.getParameters());
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            IlrXULogEvent msg = new IlrXULogEvent(new Object[]{System.currentTimeMillis(), logRecord.getLevel(), logRecordMessage, stack});
            LinkedList<IlrXULogEvent> linkedList = this.messages;
            synchronized (linkedList) {
                this.messages.addLast(msg);
                while (this.messages.size() > 50) {
                    this.messages.removeFirst();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object[] getLogEvents(Locale locale) {
            LinkedList<IlrXULogEvent> linkedList = this.messages;
            synchronized (linkedList) {
                ArrayList<Object[]> events = new ArrayList<Object[]>(this.messages.size());
                for (IlrXULogEvent msg : this.messages) {
                    events.add(msg.toObject(msg.getMessage()));
                }
                return new IlrXURulesetLogs(this.warningCount, this.errorCount, events).toObject();
            }
        }

        void resetLogs() {
            this.messages = new LinkedList();
            this.warningCount = 0L;
            this.errorCount = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetWarnings() {
            LinkedList<IlrXULogEvent> linkedList = this.messages;
            synchronized (linkedList) {
                for (int i = 0; i < this.messages.size(); ++i) {
                    if (!Level.WARNING.equals(this.messages.get(i).getLevel())) continue;
                    this.messages.remove(i);
                    --i;
                }
            }
            this.warningCount = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetErrors() {
            LinkedList<IlrXULogEvent> linkedList = this.messages;
            synchronized (linkedList) {
                for (int i = 0; i < this.messages.size(); ++i) {
                    if (!Level.SEVERE.equals(this.messages.get(i).getLevel())) continue;
                    this.messages.remove(i);
                    --i;
                }
            }
            this.errorCount = 0L;
        }
    }
}

