/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.persistence.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.persistence.internal.PersistencePropertiesConverter;
import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import com.ibm.rules.res.xu.log.internal.XULogRecordFactory;
import com.ibm.rules.res.xu.persistence.internal.PersistenceException;
import ilog.rules.archive.IlrInternalRulesetArchiveHelper;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.xu.event.IlrProfilingRulesetInformationProviderEvent;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEvent;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEventListener;
import ilog.rules.bres.xu.profiling.IlrProfilingHelper;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.model.internal.IlrRulesetArchivePropertiesImpl;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.persistence.IlrPersistenceException;
import ilog.rules.res.xu.ruleset.archive.internal.IlrRulesetArchiveInformationNotFoundException;
import ilog.rules.res.xu.ruleset.archive.internal.IlrWeakXURulesetArchiveInformationCache;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformationImpl;
import ilog.rules.res.xu.ruleset.cache.internal.IlrSolvedRulesetPathCache;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetAlreadyParsingException;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetPathException;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetPathSolver;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Persistence
implements IlrRulesetPathSolver,
Serializable,
IlrRulesetArchiveEventListener {
    private static final long serialVersionUID = 1L;
    private static final String DELAY_PROPERTY_NAME = "DELAY";
    private IlrWeakXURulesetArchiveInformationCache cache = new IlrWeakXURulesetArchiveInformationCache(this);
    private IlrXUEventDispatcher eventDispatcher;
    private IlrProfilingHelper profiling;
    private Map<String, String> properties;
    private transient Logger log;
    private boolean concurrentPersistence = false;
    private final IlrSolvedRulesetPathCache solvedPathCache = new IlrSolvedRulesetPathCache();
    private int delay;
    private HashSet<String> retrievingArchives = new HashSet();
    private HashSet<String> changedArchives = new HashSet();

    public void setLogger(Logger log) {
        this.log = log;
        this.cache.setLogger(log);
    }

    @Override
    public synchronized String getCanonicalRulesetPath(String rulesetPath) throws IlrRulesetPathException, PersistenceException, IlrRulesetArchiveInformationNotFoundException {
        String canonicalRulesetPath = this.solvedPathCache.get(rulesetPath);
        if (canonicalRulesetPath == null) {
            canonicalRulesetPath = this.solveCanonicalRulesetPath(rulesetPath);
            this.solvedPathCache.put(rulesetPath, canonicalRulesetPath);
        }
        return canonicalRulesetPath;
    }

    public void dump(XUInfoImpl dump) {
        dump.setPersistenceInfo(this.getClass().getName().toString(), this.properties, this.concurrentPersistence);
        this.solvedPathCache.dump(dump);
        this.cache.dump(dump);
    }

    public IlrXURulesetArchiveInformation getDeprecatedRulesetArchiveInformation(String rulesetPath, ClassLoader xomClassLoader) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(new XUSourceLogRecord.Entry(new Object[]{rulesetPath, xomClassLoader}));
        }
        return this.cache.getDeprecatedRulesetArchiveInformation(rulesetPath, xomClassLoader);
    }

    protected IlrXURulesetArchiveInformation retrieveRulesetArchiveInformation(String canonicalPath, IlrRulesetArchiveProperties props, ClassLoader xomCL, IlrXUContext ctx) throws IlrRulesetArchiveInformationNotFoundException, PersistenceException, IlrFormatException {
        IlrRESRulesetArchive archive = this.getRESRulesetArchive(canonicalPath, ctx);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(new XUSourceLogRecord(Level.FINEST, "use XOM classLoader: " + xomCL, new Object[0]));
        }
        IlrPath path = IlrPath.parsePath(canonicalPath);
        String[] uris = props.getManagedXOMURIs();
        ClassLoader mXOMCL = uris != null && uris.length > 0 ? this.getManagedXOMClassLoader(path, xomCL) : null;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(new XUSourceLogRecord(Level.FINEST, "Managed XOM classLoader: " + mXOMCL, new Object[0]));
        }
        if (archive instanceof IlrCRERulesetArchive) {
            try {
                IlrRulesetArchive creArchive = ((IlrCRERulesetArchive)archive).getRulesetArchive();
                int major = IlrInternalRulesetArchiveHelper.getMajorVersion((IlrRulesetArchive)creArchive);
                int minor = IlrInternalRulesetArchiveHelper.getMinorVersion((IlrRulesetArchive)creArchive);
                this.log.log(XULogRecordFactory.createXULogRecord(Level.INFO, XUMessageCode.INFO_RULESET_ARCHIVE_PRODUCER_VERSION, null, new Object[]{canonicalPath, major, minor}, ctx));
            }
            catch (IllegalAccessError e) {
                this.log.log(XULogRecordFactory.createXULogRecord(Level.FINE, XUMessageCode.INFO_RULESET_ARCHIVE_PRODUCER_VERSION_CANNOT_BE_RETRIEVED, e, new Object[]{canonicalPath}, ctx));
            }
        }
        return new IlrXURulesetArchiveInformationImpl(path, xomCL, mXOMCL, props, archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePerformed(IlrRulesetArchiveEvent event) {
        HashSet<String> hashSet = this.changedArchives;
        synchronized (hashSet) {
            this.changedArchives.add(event.getCanonicalRulesetPath());
        }
    }

    public IlrXURulesetArchiveInformation getRulesetArchiveInformation(String path, ClassLoader xomCL, IlrXUContext xuContext) throws IlrRulesetArchiveInformationNotFoundException, IlrRulesetPathException, PersistenceException {
        try {
            return this.getRulesetArchiveInformation(path, xomCL, xuContext, true);
        }
        catch (IlrRulesetAlreadyParsingException e) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IlrXURulesetArchiveInformation getRulesetArchiveInformation(String path, ClassLoader xomCL, IlrXUContext xuContext, boolean blocking) throws IlrRulesetArchiveInformationNotFoundException, IlrRulesetPathException, PersistenceException, IlrRulesetAlreadyParsingException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(new XUSourceLogRecord(Level.FINEST, "use XOM classLoader: " + xomCL, new Object[0]));
        }
        canonicalPath = this.getCanonicalRulesetPath(path);
        while (true) {
            var8_7 = this.retrievingArchives;
            synchronized (var8_7) {
                info = this.cache.get(canonicalPath, xomCL);
                if (info != null) {
                    return info;
                }
                if (this.retrievingArchives.contains(canonicalPath)) {
                    if (blocking == false) throw new IlrRulesetAlreadyParsingException("XU.ERROR.10406", null);
                    try {
                        this.retrievingArchives.wait();
                    }
                    catch (InterruptedException e) {
                        throw new PersistenceException("XU.ERROR.10059", new String[]{canonicalPath.toString()}, (Throwable)e);
                    }
                } else {
                    this.retrievingArchives.add(canonicalPath);
                    break;
                }
            }
        }
        while (true) {
            block29: {
                try {
                    var8_7 = this.changedArchives;
                    synchronized (var8_7) {
                        this.changedArchives.remove(canonicalPath);
                        ** if (this.delay <= 0) goto lbl33
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Thread.sleep(this.delay);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
lbl33:
                    // 3 sources

                    props = this.getRulesetArchiveProperties(canonicalPath, xuContext);
                    info = this.retrieveRulesetArchiveInformation(canonicalPath, props, xomCL, xuContext);
                    e = this.changedArchives;
                    synchronized (e) {
                        if (this.changedArchives.contains(canonicalPath)) break block29;
                        var9_11 = this.cache;
                        synchronized (var9_11) {
                            info = this.cache.add(canonicalPath, info);
                            this.cache.add(path, info);
                            var10_13 = info;
                        }
                    }
                    var11_14 = this.retrievingArchives;
                }
                catch (Throwable var15_15) {
                    var16_16 = this.retrievingArchives;
                    synchronized (var16_16) {
                        this.retrievingArchives.remove(canonicalPath);
                        this.retrievingArchives.notifyAll();
                        throw var15_15;
                    }
                }
                {
                    catch (IlrFormatException e) {
                        throw new IlrRulesetPathException("XU.ERROR.10048", new String[]{canonicalPath}, (Throwable)e);
                    }
                }
                synchronized (var11_14) {
                    this.retrievingArchives.remove(canonicalPath);
                    this.retrievingArchives.notifyAll();
                    return var10_13;
                }
            }
        }
    }

    public void setEventDispatcher(IlrXUEventDispatcher eventDispatcher) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.removeListener(this.cache, 8193L);
            this.eventDispatcher.removeListener(this.solvedPathCache, 1L);
        }
        this.eventDispatcher = eventDispatcher;
        this.eventDispatcher.addListener(this.solvedPathCache, 1L, (byte)127);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(new XUSourceLogRecord(Level.FINEST, "register archive cache to the event dispatcher", new Object[0]));
        }
        this.eventDispatcher.addListener(this.cache, 8193L, (byte)126);
    }

    public void setProfiling(IlrProfilingHelper profiling) {
        this.profiling = profiling;
    }

    protected synchronized Map<String, String> getProperties() {
        return this.properties;
    }

    public synchronized void setProperties(Map<String, String> props) throws IlrPersistenceException {
        this.log.log(new XUSourceLogRecord.Entry(PersistencePropertiesConverter.obfuscate(props)));
        this.properties = props;
        String value = props.get("CONCURRENT_PERSISTENCE_ACCESS");
        if (value != null) {
            this.concurrentPersistence = Boolean.valueOf(value);
        }
        if ((value = props.get(DELAY_PROPERTY_NAME)) != null) {
            this.delay = Integer.valueOf(value);
        }
        this.log.log(new XUSourceLogRecord.Exit());
    }

    public void destroy() {
        this.cache = null;
        this.eventDispatcher = null;
        this.profiling = null;
        this.properties = null;
    }

    protected final Logger getLogger() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IlrRulesetArchiveProperties getRulesetArchiveProperties(String canonicalPath, IlrXUContext xuContext) throws IlrRulesetArchiveInformationNotFoundException, PersistenceException {
        Map<String, String> props;
        IlrProfilingRulesetInformationProviderEvent evt = this.profiling.startRulesetInformationProviderMeasure(3, this, canonicalPath, xuContext);
        if (!this.concurrentPersistence) {
            Persistence persistence = this;
            synchronized (persistence) {
                props = this.retrieveRulesetArchiveProperties(canonicalPath);
            }
        } else {
            props = this.retrieveRulesetArchiveProperties(canonicalPath);
        }
        IlrRulesetArchivePropertiesImpl aProps = new IlrRulesetArchivePropertiesImpl(props);
        this.profiling.stopRulesetInformationProviderMeasure(evt);
        this.profiling.sendRulesetInformationProviderEvent(evt);
        return aProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IlrRESRulesetArchive getRESRulesetArchive(String canonicalRulesetPath, IlrXUContext context) throws IlrRulesetArchiveInformationNotFoundException, PersistenceException {
        IlrRESRulesetArchive archive;
        block6: {
            this.log.log(new XUSourceLogRecord(Level.FINEST, "retrieve " + canonicalRulesetPath, new Object[0]));
            archive = null;
            try {
                if (!this.concurrentPersistence) {
                    Persistence persistence = this;
                    synchronized (persistence) {
                        archive = this.retrieveRESRulesetArchive(IlrPath.parsePath(canonicalRulesetPath));
                        break block6;
                    }
                }
                archive = this.retrieveRESRulesetArchive(IlrPath.parsePath(canonicalRulesetPath));
            }
            catch (IlrFormatException e) {
                throw new PersistenceException("XU.ERROR.10059", new String[]{canonicalRulesetPath.toString()}, (Throwable)e);
            }
        }
        return archive;
    }

    protected abstract Map<String, String> retrieveRulesetArchiveProperties(String var1) throws IlrRulesetArchiveInformationNotFoundException, PersistenceException;

    protected abstract IlrRESRulesetArchive retrieveRESRulesetArchive(IlrPath var1) throws IlrPersistenceException;

    protected abstract String solveCanonicalRulesetPath(String var1) throws IlrRulesetPathException, PersistenceException, IlrRulesetArchiveInformationNotFoundException;

    public ClassLoader getEngineLibClassLoader(String v) throws PersistenceException {
        ClassLoader c = this.getEngineLibClassLoaderFromDir(v);
        if (c == null) {
            c = this.getEngineLibClassLoaderFromResource(v);
        }
        if (c == null) {
            throw new PersistenceException(XUMessageCode.ERROR_ENGINE_LIB_NOT_FOUND, new String[]{v}, null);
        }
        return c;
    }

    private ClassLoader getEngineLibClassLoaderFromDir(String v) throws PersistenceException {
        return null;
    }

    private ClassLoader getEngineLibClassLoaderFromResource(String v) throws PersistenceException {
        URLClassLoader c;
        this.log.log(new XUSourceLogRecord.Entry(v));
        String name = "odm-de-" + v + ".api";
        URL u = this.getClass().getClassLoader().getResource(name);
        if (u == null) {
            u = ClassLoader.getSystemResource(name);
        }
        if (u == null) {
            c = null;
            this.log.log(new XUSourceLogRecord(Level.FINEST, "engine lib " + v + "not found in resources", new Object[0]));
        } else {
            c = new URLClassLoader(new URL[]{u});
            this.log.log(new XUSourceLogRecord(Level.FINEST, "url of the engine lib " + v + ": " + u, new Object[0]));
        }
        this.log.log(new XUSourceLogRecord.Exit(c));
        return c;
    }

    protected abstract ClassLoader getManagedXOMClassLoader(IlrPath var1, ClassLoader var2) throws IlrRulesetArchiveInformationNotFoundException, PersistenceException;
}

