/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.persistence.internal;

import com.ibm.rules.res.xu.persistence.internal.Persistence;
import com.ibm.rules.res.xu.persistence.internal.PersistenceException;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRESRulesetArchiveCreationException;
import ilog.rules.res.model.IlrRESRulesetArchiveFactory;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.xu.persistence.IlrPersistenceException;
import ilog.rules.res.xu.ruleset.archive.internal.IlrRulesetArchiveInformationNotFoundException;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetPathException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class ResourcePersistence
extends Persistence {
    private static final long serialVersionUID = 1L;
    private final ClassLoader classLoader = this.getClass().getClassLoader();

    private InputStream getResourceAsStream(String resPath) {
        InputStream in = this.classLoader.getResourceAsStream(resPath);
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(resPath);
        }
        return in;
    }

    @Override
    protected final ClassLoader getManagedXOMClassLoader(IlrPath path, ClassLoader managedXOMCL) throws IlrRulesetArchiveInformationNotFoundException, IlrPersistenceException {
        return managedXOMCL;
    }

    @Override
    protected final Map<String, String> retrieveRulesetArchiveProperties(String canonicalRulesetPath) throws IlrRulesetArchiveInformationNotFoundException, IlrPersistenceException {
        String propsPath = canonicalRulesetPath.substring(1) + "/properties.txt";
        InputStream in = this.getResourceAsStream(propsPath);
        if (in == null) {
            throw new IlrRulesetArchiveInformationNotFoundException("XU.ERROR.10008", new String[]{canonicalRulesetPath}, null);
        }
        Properties oldProps = new Properties();
        try {
            oldProps.load(in);
        }
        catch (IOException e) {
            throw new IlrPersistenceException("XU.ERROR.10059", new String[]{canonicalRulesetPath}, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : oldProps.entrySet()) {
            props.put(e.getKey().toString(), e.getValue().toString());
        }
        return props;
    }

    @Override
    protected IlrRESRulesetArchive retrieveRESRulesetArchive(IlrPath canonicalRulesetPath) throws IlrPersistenceException {
        InputStream in = null;
        try {
            IlrRulesetArchiveProperties props = this.getRulesetArchiveProperties(canonicalRulesetPath.toString(), null);
            String resPath = props.getEngineType() == IlrEngineType.CRE ? canonicalRulesetPath.toString().substring(1) + "/ruleset.jar" : canonicalRulesetPath.toString().substring(1) + "/ruleset.dsar";
            in = this.getResourceAsStream(resPath);
            IlrRESRulesetArchive ilrRESRulesetArchive = IlrRESRulesetArchiveFactory.createRESRulesetArchive(props.getEngineType(), in);
            return ilrRESRulesetArchive;
        }
        catch (IlrRulesetArchiveInformationNotFoundException e) {
            throw new IlrPersistenceException("XU.ERROR.10059", new String[]{canonicalRulesetPath.toString()}, (Throwable)e);
        }
        catch (IlrRESRulesetArchiveCreationException e) {
            throw new IlrPersistenceException("XU.ERROR.10059", new String[]{canonicalRulesetPath.toString()}, (Throwable)e);
        }
        catch (PersistenceException e) {
            throw new IlrPersistenceException("XU.ERROR.10059", new String[]{canonicalRulesetPath.toString()}, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    protected String solveCanonicalRulesetPath(String rulesetPath) throws IlrRulesetPathException, IlrPersistenceException, IlrRulesetArchiveInformationNotFoundException {
        try {
            IlrPath p = IlrPath.parsePath(rulesetPath);
            if (p.isCanonical()) {
                return rulesetPath;
            }
            throw new UnsupportedOperationException();
        }
        catch (IlrFormatException e) {
            throw new IlrPersistenceException("XU.ERROR.10059", new String[]{rulesetPath}, (Throwable)e);
        }
    }
}

