/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.plugin.internal;

import com.ibm.rules.res.xu.client.info.internal.XUInfo;
import com.ibm.rules.res.xu.client.internal.XUClient;
import com.ibm.rules.res.xu.client.internal.XURuleEngineSession;
import com.ibm.rules.res.xu.client.internal.XUSession;
import com.ibm.rules.res.xu.config.internal.XUConfig;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.plugin.PluginException;
import com.ibm.rules.res.xu.spi.internal.XUResourceAdapter;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.xu.cci.IlrInteractionExtension;
import ilog.rules.res.xu.cci.IlrXUConnectionFactory;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.plugin.internal.IlrPlugin;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformationMonitor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.resource.spi.work.WorkManager;

public class PluginBase
implements IlrPlugin {
    private Map<String, String> props;
    private IlrRulesetUsageInformationMonitor monitor;
    private boolean startRequested = false;
    private boolean released = false;
    private LogHandler logger;
    private XUConfig cfg;
    private XUResourceAdapter ra;
    private IlrXUConnectionFactory connFactory;

    @Override
    public final void setConnectionFactory(IlrXUConnectionFactory connFactory) {
        this.connFactory = connFactory;
    }

    public final synchronized XUInfo getXUInfo() throws XUException {
        if (!this.startRequested || this.released) {
            throw new IllegalStateException();
        }
        if (this.connFactory == null) {
            return null;
        }
        return this.connFactory.getXUInfo();
    }

    @Override
    public final void setXUConfig(XUConfig cfg) {
        this.cfg = cfg;
    }

    @Override
    public final void setResourceAdapter(XUResourceAdapter ra) {
        this.ra = ra;
    }

    @Override
    public final void setLogHandler(LogHandler logger) {
        this.logger = logger;
    }

    @Override
    public final void setProperties(Properties properties) throws PluginException {
        this.props = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            this.props.put((String)e.getKey(), (String)e.getValue());
        }
    }

    @Override
    public final void subscribe(IlrXUEventDispatcher xuEventDispatcher) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void unsubscribe(IlrXUEventDispatcher xuEventDispatcher) {
        throw new UnsupportedOperationException();
    }

    public final boolean isLoggable(Level l) {
        return this.logger.isLoggable(l);
    }

    @Override
    public final synchronized void start() throws PluginException {
        this.startRequested = true;
        try {
            this.start(this.props);
        }
        catch (PluginException e) {
            throw new PluginException("XU.ERROR.10020", new Object[]{this.getClass().getName()}, (Throwable)e);
        }
    }

    public void start(Map<String, String> props) throws PluginException {
    }

    public void release() {
    }

    @Override
    public final synchronized void destroy() throws PluginException {
        this.release();
        this.released = true;
        this.props = null;
        this.monitor = null;
    }

    @Override
    public IlrInteractionExtension getInteractionExtension() {
        return null;
    }

    @Override
    public final synchronized void setRulesetUsageInformationMonitor(IlrRulesetUsageInformationMonitor monitor) {
        this.monitor = monitor;
    }

    public synchronized IlrRulesetUsageInformationMonitor getRulesetUsageInformationMonitor() {
        if (!this.startRequested || this.released) {
            throw new IllegalStateException();
        }
        return this.monitor;
    }

    public synchronized void notifyRulesetArchiveChanged(IlrPath path) {
        if (!this.startRequested || this.released) {
            throw new IllegalStateException();
        }
        if (!path.isCanonical()) {
            throw new IllegalArgumentException();
        }
        this.ra.notifyRulesetArchiveChanged(path, null);
    }

    public final synchronized XUConfig getXUConfig() {
        if (!this.startRequested || this.released) {
            throw new IllegalStateException();
        }
        return this.cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Map<String, Object> executeRuleset(IlrPath path, Map<String, Object> params, Serializable userData, boolean forUptodateRuleset) throws XUException {
        if (!this.startRequested || this.released) {
            throw new IllegalStateException();
        }
        if (userData == null) {
            userData = this.getClass().getName();
        }
        XUClient cl = XUClient.createXUClient(this.connFactory);
        XUSession sess = null;
        try {
            sess = cl.createRuleEngineSession(path, null, null, (Serializable)userData, "8.7.1.0");
            if (forUptodateRuleset) {
                ((XURuleEngineSession)sess).loadUptodateRuleset();
            }
            if (params != null) {
                ((XURuleEngineSession)sess).setParameters(params);
            }
            Map<String, Object> map = ((XURuleEngineSession)sess).execute();
            return map;
        }
        finally {
            if (sess != null) {
                sess.close();
            }
        }
    }

    public final synchronized Map<String, Object> executeRuleset(IlrPath path, Map<String, Object> params, Serializable userData) throws XUException {
        return this.executeRuleset(path, params, userData, false);
    }

    public final synchronized void log(LogRecord rec) {
        if (!this.startRequested || this.released) {
            throw new IllegalStateException();
        }
        if (this.logger != null) {
            this.logger.log(rec);
        }
    }

    public final synchronized WorkManager getWorkManager() {
        if (!this.startRequested || this.released) {
            throw new IllegalStateException();
        }
        return this.ra.getWorkManager();
    }
}

