/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.pool.internal;

import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.pool.internal.PoolImpl;
import ilog.rules.res.xu.spi.IlrManagedXUConnection;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;

public class ManagedConnectionPool
extends PoolImpl<IlrManagedXUConnection> {
    protected final WorkManager workMgr;
    protected final LogHandler logger;
    protected long maintenancePeriod;
    protected long idleTimeout;
    private static IlrManagedXUConnection[] connArray = new IlrManagedXUConnection[0];

    public ManagedConnectionPool(WorkManager workMgr, LogHandler logger) {
        this.workMgr = workMgr;
        this.logger = logger;
    }

    @Override
    public void initialize(Map<String, String> props) {
        super.initialize(props);
        String str = props.get("connection.maintenancePeriod");
        this.maintenancePeriod = str == null || str.trim().equals("") ? -1L : (long)(Integer.parseInt(str) * 1000);
        str = props.get("connection.idleTimeout");
        this.idleTimeout = str == null || str.trim().equals("") ? -1L : (long)(Integer.parseInt(str) * 1000);
        this.logger.finest("ManagedConnectionPool.initialize() maintenancePeriod = " + this.maintenancePeriod + " idleTimeout = " + this.idleTimeout);
        if (this.maintenancePeriod != -1L && this.idleTimeout != -1L) {
            try {
                this.workMgr.startWork((Work)new PurgeWork(this));
            }
            catch (WorkException workException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void purge() {
        this.logger.finest("ManagedConnectionPool.purge() usedObjects.size() = " + this.usedObjects.size());
        long time = System.currentTimeMillis();
        IlrManagedXUConnection[] conns = this.usedObjects.toArray(connArray);
        this.logger.finest("ManagedConnectionPool.purge() conns.length = " + conns.length);
        if (conns.length == 0) {
            return;
        }
        for (IlrManagedXUConnection conn : conns) {
            this.logger.finest("ManagedConnectionPool.purge() conn=" + conn);
            IlrManagedXUConnection ilrManagedXUConnection = conn;
            synchronized (ilrManagedXUConnection) {
                long connTime = conn.getLastRunningTime();
                this.logger.finest("ManagedConnectionPool.purge() conn.lastRunningTime=" + connTime);
                if (time - connTime > this.idleTimeout) {
                    try {
                        conn.closeAll();
                    }
                    catch (ResourceException e) {
                        // empty catch block
                    }
                }
            }
        }
        this.logger.finest("ManagedConnectionPool.purge() ends");
    }

    protected class PurgeWork
    implements Work {
        protected final ManagedConnectionPool pool;
        protected boolean stopRequested = false;

        protected PurgeWork(ManagedConnectionPool pool) {
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            while (true) {
                PurgeWork purgeWork = this;
                synchronized (purgeWork) {
                    if (this.stopRequested) {
                        break;
                    }
                }
                try {
                    Thread.sleep(ManagedConnectionPool.this.maintenancePeriod);
                    this.pool.purge();
                }
                catch (InterruptedException e) {
                    ManagedConnectionPool.this.logger.finest(this + " has been interrupted");
                }
            }
            ManagedConnectionPool.this.logger.finest("PurgeWork stopped");
        }

        public synchronized void release() {
            this.stopRequested = true;
        }
    }
}

