/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.pool.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.log.internal.XULogRecordFactory;
import com.ibm.rules.res.xu.pool.internal.BasePoolImpl;
import com.ibm.rules.res.xu.pool.internal.ObjectFactory;
import com.ibm.rules.res.xu.pool.internal.SizedPool;
import ilog.rules.res.xu.pool.IlrPoolException;
import java.util.Map;
import java.util.logging.Level;

public abstract class SizedPoolImpl<T>
extends BasePoolImpl<T>
implements SizedPool<T> {
    public static final int DEFAULT_MAX_POOL_SIZE = 10;
    public static final String PROPERTY_KEY_MAX_SIZE = "pool.maxSize";
    protected int maxPoolSize = 10;

    @Override
    public int getMaxSize() {
        return this.maxPoolSize;
    }

    public void initialize(Map<String, String> properties, ObjectFactory<T> factory) {
        if (this.log != null) {
            this.log.log(XULogRecordFactory.createXULogRecord(Level.INFO, XUMessageCode.INFO_CONNECTION_POOL_INITIALIZE, null, new Object[]{this.getDisplayName()}, null));
            this.log.log(XULogRecordFactory.createXULogRecord(Level.INFO, XUMessageCode.INFO_CONNECTION_POOL_PROPERTIES, null, new Object[]{this.getDisplayName(), properties}, null));
        }
        int s = 10;
        String strMaxSize = properties.get(PROPERTY_KEY_MAX_SIZE);
        if (strMaxSize != null) {
            s = Integer.parseInt(strMaxSize);
        }
        super.initialize(factory);
        this.maxPoolSize = s;
    }

    @Override
    public T get() throws IlrPoolException, UnsupportedOperationException {
        if (this.maxPoolSize == 0) {
            return this.factory.create();
        }
        return super.get();
    }
}

