/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.ruleset.internal;

import com.ibm.rules.engine.ruledef.runtime.Rule;
import com.ibm.rules.engine.ruledef.runtime.RuleAction;
import com.ibm.rules.engine.ruleflow.runtime.RuleflowEngineDefinition;
import com.ibm.rules.engine.ruleflow.runtime.Task;
import com.ibm.rules.engine.ruleflow.util.EngineDefinitionHelper;
import com.ibm.rules.engine.runtime.EngineDefinition;
import com.ibm.rules.engine.runtime.EngineSignature;
import com.ibm.rules.engine.util.CustomProperties;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.engine.de.internal.DEEngine;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.io.internal.SerializableUtil;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import ilog.rules.bom.IlrType;
import ilog.rules.engine.IlrRuleset;
import ilog.rules.factory.IlrReflect;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.xu.cci.ruleset.impl.IlrRuleInformationImpl;
import ilog.rules.res.xu.cci.ruleset.impl.IlrTaskInformationImpl;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import ilog.rules.util.IlrIdConverter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DERulesetImpl
extends XURulesetImpl {
    private final EngineDefinition deRuleset;
    private IlrReflect reflect;

    public DERulesetImpl(EngineDefinition deRuleset, String canonicalRulesetPath, IlrRulesetArchiveProperties archiveProps, ClassLoader xomClassLoader, IlrXURulesetArchiveInformation archive, Collection<String> warnings, LogHandler logger, IlrRulesetUsageInformationImpl usage) {
        super(canonicalRulesetPath, archiveProps, xomClassLoader, archive, warnings, logger, usage);
        this.deRuleset = deRuleset;
    }

    @Override
    protected final Object getRootObject() {
        return this.deRuleset;
    }

    @Override
    protected final Map<String, IlrRuleInformation> retrieveAllRules() {
        EngineDefinition def = this.deRuleset;
        List defRules = EngineDefinitionHelper.GetRules((EngineDefinition)def);
        HashMap<String, IlrRuleInformation> allRules = new HashMap<String, IlrRuleInformation>(defRules.size());
        for (Rule defRule : defRules) {
            IlrRuleInformationImpl rule;
            String bRuleName = defRule.getName();
            List defRuleActions = defRule.getRuleActions();
            boolean isDT = DEEngine.isDTRule(defRule);
            CustomProperties defRuleProps = defRule.getProperties();
            Map<String, Serializable> props = SerializableUtil.toSerializableMap(defRuleProps);
            if (isDT) {
                if (defRuleActions == null || defRuleActions.size() <= 0) continue;
                for (RuleAction a : defRuleActions) {
                    rule = this.createRuleInformation(bRuleName, isDT, props, a);
                    allRules.put(rule.getName(), rule);
                }
                continue;
            }
            rule = this.createRuleInformation(bRuleName, isDT, props, null);
            allRules.put(rule.getName(), rule);
        }
        return allRules;
    }

    private void finest(String msg) {
        this.logger.finest(this.getClass().getName() + msg);
    }

    private IlrRuleInformationImpl createRuleInformation(String bRuleName, boolean isDT, Map<String, Serializable> props, RuleAction a) {
        String technicalName;
        String businessName;
        String actionName;
        if (isDT) {
            if (a == null) {
                this.finest(".createRuleInformation: fails to parse the DT line,  business rule name=" + bRuleName + " , ilog.rules.dt=" + props.get("ilog.rules.dt") + " , action=null");
                throw new IllegalArgumentException();
            }
            actionName = a.getName();
            try {
                long dtLine = Long.parseLong(actionName);
                businessName = bRuleName + " " + dtLine;
                technicalName = IlrIdConverter.getEngineIdentifier(bRuleName) + "_" + (dtLine - 1L);
            }
            catch (NumberFormatException e) {
                this.finest(".createRuleInformation: fails to parse the DT line,  business rule name=" + bRuleName + " , ilog.rules.dt=" + props.get("ilog.rules.dt") + " , action=" + a.getName());
                throw e;
            }
        } else {
            actionName = null;
            businessName = bRuleName;
            technicalName = IlrIdConverter.getEngineIdentifier(businessName);
        }
        return new IlrRuleInformationImpl(technicalName, businessName, props, actionName);
    }

    @Override
    public final Map<String, IlrTaskInformation> retrieveAllTasks() {
        EngineDefinition def = this.deRuleset;
        HashMap<String, IlrTaskInformation> result = new HashMap<String, IlrTaskInformation>();
        if (def instanceof RuleflowEngineDefinition) {
            RuleflowEngineDefinition rfEngineDef = (RuleflowEngineDefinition)def;
            List tasks = rfEngineDef.getTasks();
            for (Task task : tasks) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                String name = task.getName();
                String technicalName = DEEngine.toTechnicalName(task);
                IlrTaskInformationImpl t = new IlrTaskInformationImpl(technicalName, name, props);
                result.put(technicalName, t);
            }
        }
        return result;
    }

    @Override
    protected XURulesetParameter[] retrieveRulesetParameters() {
        EngineSignature sig = this.deRuleset.getSignature();
        Collection params = sig.getAllParameters();
        XURulesetParameter[] result = new XURulesetParameter[params.size()];
        int i = 0;
        for (EngineSignature.Parameter p : params) {
            result[i++] = this.createRulesetParameter(p);
        }
        return result;
    }

    private final XURulesetParameter createRulesetParameter(EngineSignature.Parameter p) {
        String name = p.getName();
        String typeName = p.getParameterTypeName();
        byte kind = DEEngine.getKind(p);
        IlrType xmlType = kind == 1 ? DEEngine.getXMLType(p, this.deRuleset) : null;
        byte dir = DEEngine.getDir(p);
        return DERulesetImpl.createRulesetParameter(name, kind, dir, xmlType, typeName, p.getArrayDimension());
    }

    public final EngineDefinition getRuleset() {
        return this.deRuleset;
    }

    @Override
    public IlrRuleset getCRERuleset() {
        return null;
    }

    @Override
    public synchronized IlrReflect getBOMReflect() throws XUException {
        if (this.reflect == null) {
            this.reflect = DEEngine.getBOMReflect(this.deRuleset);
        }
        return this.reflect;
    }
}

